import{s as pe,n as ue,o as ce}from"../chunks/scheduler.c59d9fbb.js";import{S as he,i as we,g as o,s as l,r as Q,A as ve,h as s,f as a,c as i,j as de,u as S,x as r,k as fe,y as ge,a as n,v as W,d as N,t as Z,w as X}from"../chunks/index.a47918e3.js";import{H as O,g as be}from"../chunks/Heading.fb623c98.js";import{C as Te}from"../chunks/CodeBlock.936db8cd.js";function ye(K){let m,$,A,k,d,J,f,Y=`This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2205.05638" rel="nofollow">IA3</a>, a parameter-efficient fine tuning technique that is
intended to improve over <a href="./lora">LoRA</a>.`,L,p,ee=`To make fine-tuning more efficient, IA3 (Infused Adapter by Inhibiting and Amplifying Inner Activations)
rescales inner activations with learned vectors. These learned vectors are injected in the attention and feedforward modules
in a typical transformer-based architecture. These learned vectors are the only trainable parameters during fine-tuning, and thus the original
weights remain frozen. Dealing with learned vectors (as opposed to learned low-rank updates to a weight matrix like LoRA)
keeps the number of trainable parameters much smaller.`,M,u,te="Being similar to LoRA, IA3 carries many of the same advantages:",P,c,ae="<li>IA3 makes fine-tuning more efficient by drastically reducing the number of trainable parameters. (For T0, an IA3 model only has about 0.01% trainable parameters, while even LoRA has &gt; 0.1%)</li> <li>The original pre-trained weights are kept frozen, which means you can have multiple lightweight and portable IA3 models for various downstream tasks built on top of them.</li> <li>Performance of models fine-tuned using IA3 is comparable to the performance of fully fine-tuned models.</li> <li>IA3 does not add any inference latency because adapter weights can be merged with the base model.</li>",q,h,ne=`In principle, IA3 can be applied to any subset of weight matrices in a neural network to reduce the number of trainable
parameters. Following the authors’ implementation, IA3 weights are added to the key, value and feedforward layers
of a Transformer model. To be specific, for transformer models, IA3 weights are added to the outputs of key and value layers, and to the input of the second feedforward layer
in each transformer block.`,j,w,le=`Given the target layers for injecting IA3 parameters, the number of trainable parameters
can be determined based on the size of the weight matrices.`,U,v,H,g,ie="As with other methods supported by PEFT, to fine-tune a model using IA3, you need to:",E,b,oe="<li>Instantiate a base model.</li> <li>Create a configuration (<code>IA3Config</code>) where you define IA3-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",R,T,se="<code>IA3Config</code> allows you to control how IA3 is applied to the base model through the following parameters:",z,y,re=`<li><code>target_modules</code>: The modules (for example, attention blocks) to apply the IA3 vectors.</li> <li><code>feedforward_modules</code>: The list of modules to be treated as feedforward layers in <code>target_modules</code>. While learned vectors are multiplied with
the output activation for attention blocks, the vectors are multiplied with the input for classic feedforward layers. Note that <code>feedforward_modules</code> must be a subset of <code>target_modules</code>.</li> <li><code>modules_to_save</code>: List of modules apart from IA3 layers to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>`,F,_,G,I,me="For the task of sequence classification, one can initialize the IA3 config for a Llama model as follows:",V,x,B,C,D;return d=new O({props:{title:"IA3",local:"ia3",headingTag:"h1"}}),v=new O({props:{title:"Common IA3 parameters in PEFT",local:"common-ia3-parameters-in-peft",headingTag:"h2"}}),_=new O({props:{title:"Example Usage",local:"example-usage",headingTag:"h2"}}),x=new Te({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBJQTNDb25maWcoJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEVGFza1R5cGUuU0VRX0NMUyUyQyUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyZG93bl9wcm9qJTIyJTVEJTJDJTIwZmVlZGZvcndhcmRfbW9kdWxlcyUzRCU1QiUyMmRvd25fcHJvaiUyMiU1RCUwQSk=",highlighted:`peft_config = IA3Config(
    task_type=TaskType.SEQ_CLS, target_modules=[<span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>], feedforward_modules=[<span class="hljs-string">&quot;down_proj&quot;</span>]
)`,wrap:!1}}),{c(){m=o("meta"),$=l(),A=o("p"),k=l(),Q(d.$$.fragment),J=l(),f=o("p"),f.innerHTML=Y,L=l(),p=o("p"),p.textContent=ee,M=l(),u=o("p"),u.textContent=te,P=l(),c=o("ul"),c.innerHTML=ae,q=l(),h=o("p"),h.textContent=ne,j=l(),w=o("p"),w.textContent=le,U=l(),Q(v.$$.fragment),H=l(),g=o("p"),g.textContent=ie,E=l(),b=o("ol"),b.innerHTML=oe,R=l(),T=o("p"),T.innerHTML=se,z=l(),y=o("ul"),y.innerHTML=re,F=l(),Q(_.$$.fragment),G=l(),I=o("p"),I.textContent=me,V=l(),Q(x.$$.fragment),B=l(),C=o("p"),this.h()},l(e){const t=ve("svelte-u9bgzb",document.head);m=s(t,"META",{name:!0,content:!0}),t.forEach(a),$=i(e),A=s(e,"P",{}),de(A).forEach(a),k=i(e),S(d.$$.fragment,e),J=i(e),f=s(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1f08nkr"&&(f.innerHTML=Y),L=i(e),p=s(e,"P",{"data-svelte-h":!0}),r(p)!=="svelte-iyuejo"&&(p.textContent=ee),M=i(e),u=s(e,"P",{"data-svelte-h":!0}),r(u)!=="svelte-mvs6w2"&&(u.textContent=te),P=i(e),c=s(e,"UL",{"data-svelte-h":!0}),r(c)!=="svelte-1d130bu"&&(c.innerHTML=ae),q=i(e),h=s(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-x58frj"&&(h.textContent=ne),j=i(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-wbgvs7"&&(w.textContent=le),U=i(e),S(v.$$.fragment,e),H=i(e),g=s(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-16q36ht"&&(g.textContent=ie),E=i(e),b=s(e,"OL",{"data-svelte-h":!0}),r(b)!=="svelte-1sklxcv"&&(b.innerHTML=oe),R=i(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-wdoadq"&&(T.innerHTML=se),z=i(e),y=s(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-crbpqt"&&(y.innerHTML=re),F=i(e),S(_.$$.fragment,e),G=i(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-hieagv"&&(I.textContent=me),V=i(e),S(x.$$.fragment,e),B=i(e),C=s(e,"P",{}),de(C).forEach(a),this.h()},h(){fe(m,"name","hf:doc:metadata"),fe(m,"content",_e)},m(e,t){ge(document.head,m),n(e,$,t),n(e,A,t),n(e,k,t),W(d,e,t),n(e,J,t),n(e,f,t),n(e,L,t),n(e,p,t),n(e,M,t),n(e,u,t),n(e,P,t),n(e,c,t),n(e,q,t),n(e,h,t),n(e,j,t),n(e,w,t),n(e,U,t),W(v,e,t),n(e,H,t),n(e,g,t),n(e,E,t),n(e,b,t),n(e,R,t),n(e,T,t),n(e,z,t),n(e,y,t),n(e,F,t),W(_,e,t),n(e,G,t),n(e,I,t),n(e,V,t),W(x,e,t),n(e,B,t),n(e,C,t),D=!0},p:ue,i(e){D||(N(d.$$.fragment,e),N(v.$$.fragment,e),N(_.$$.fragment,e),N(x.$$.fragment,e),D=!0)},o(e){Z(d.$$.fragment,e),Z(v.$$.fragment,e),Z(_.$$.fragment,e),Z(x.$$.fragment,e),D=!1},d(e){e&&(a($),a(A),a(k),a(J),a(f),a(L),a(p),a(M),a(u),a(P),a(c),a(q),a(h),a(j),a(w),a(U),a(H),a(g),a(E),a(b),a(R),a(T),a(z),a(y),a(F),a(G),a(I),a(V),a(B),a(C)),a(m),X(d,e),X(v,e),X(_,e),X(x,e)}}}const _e='{"title":"IA3","local":"ia3","sections":[{"title":"Common IA3 parameters in PEFT","local":"common-ia3-parameters-in-peft","sections":[],"depth":2},{"title":"Example Usage","local":"example-usage","sections":[],"depth":2}],"depth":1}';function Ie(K){return ce(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=be}),[]}class ke extends he{constructor(m){super(),we(this,m,Ie,ye,pe,{})}}export{ke as component};
