import{s as ia,n as oa,o as ra}from"../chunks/scheduler.c59d9fbb.js";import{S as pa,i as Ma,g as i,s,r as p,A as ma,h as o,f as t,c as n,j as na,u as M,x as r,k as ht,y as da,a,v as m,d,t as c,w as y}from"../chunks/index.a47918e3.js";import{H as u,g as ca}from"../chunks/Heading.fb623c98.js";import{C as h}from"../chunks/CodeBlock.936db8cd.js";function ya(ut){let w,He,xe,Se,b,ze,f,wt=`This guide demonstrates how to use LoRA, a low-rank approximation technique, to finetune a SegFormer model variant for semantic segmentation.
By using LoRA from 🤗 PEFT, we can reduce the number of trainable parameters in the SegFormer model to only 14% of the original trainable parameters.`,Ne,U,Jt=`LoRA achieves this reduction by adding low-rank “update matrices” to specific blocks of the model, such as the attention
blocks. During fine-tuning, only these matrices are trained, while the original model parameters are left unchanged.
At inference time, the update matrices are merged with the original model parameters to produce the final classification result.`,Ee,T,bt='For more information on LoRA, please refer to the <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">original LoRA paper</a>.',Le,j,qe,g,ft="Install the libraries required for model training:",Ke,C,Pe,W,De,Z,Ut=`To share the finetuned model with the community at the end of the training, authenticate using your 🤗 token.
You can obtain your token from your <a href="https://huggingface.co/settings/token" rel="nofollow">account settings</a>.`,Oe,I,el,B,ll,_,Tt=`To ensure that this example runs within a reasonable time frame, here we are limiting the number of instances from the training
set of the <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">SceneParse150 dataset</a> to 150.`,tl,v,al,$,jt="Next, split the dataset into train and test sets.",sl,k,nl,G,il,R,gt="Create a dictionary that maps a label id to a label class, which will be useful when setting up the model later:",ol,X,Ct="<li><code>label2id</code>: maps the semantic classes of the dataset to integer ids.</li> <li><code>id2label</code>: maps integer ids back to the semantic classes.</li>",rl,Q,pl,A,Ml,V,Wt=`Next, load the SegFormer image processor to prepare the images and annotations for the model. This dataset uses the
zero-index as the background class, so make sure to set <code>do_reduce_labels=True</code> to subtract one from all labels since the
background class is not among the 150 classes.`,ml,Y,dl,x,Zt=`Add a function to apply data augmentation to the images, so that the model is more robust against overfitting. Here we use the
<a href="https://pytorch.org/vision/stable/generated/torchvision.transforms.ColorJitter.html" rel="nofollow">ColorJitter</a> function from
<a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a> to randomly change the color properties of an image.`,cl,F,yl,H,It=`Add a function to handle grayscale images and ensure that each input image has three color channels, regardless of
whether it was originally grayscale or RGB. The function converts RGB images to array as is, and for grayscale images
that have only one color channel, the function replicates the same channel three times using <code>np.tile()</code> before converting
the image into an array.`,hl,S,ul,z,Bt=`Finally, combine everything in two functions that you’ll use to transform training and validation data. The two functions
are similar except data augmentation is applied only to the training data.`,wl,N,Jl,E,_t="To apply the preprocessing functions over the entire dataset, use the 🤗 Datasets <code>set_transform</code> function:",bl,L,fl,q,Ul,K,vt=`Including a metric during training is helpful for evaluating your model’s performance. You can load an evaluation
method with the <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">🤗 Evaluate</a> library. For this task, use
the <a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">mean Intersection over Union (IoU)</a> metric (see the 🤗 Evaluate
<a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">quick tour</a> to learn more about how to load and compute a metric):`,Tl,P,jl,D,gl,O,$t=`Before loading a base model, let’s define a helper function to check the total number of parameters a model has, as well
as how many of them are trainable.`,Cl,ee,Wl,le,kt=`Choose a base model checkpoint. For this example, we use the <a href="https://huggingface.co/nvidia/mit-b0" rel="nofollow">SegFormer B0 variant</a>.
In addition to the checkpoint, pass the <code>label2id</code> and <code>id2label</code> dictionaries to let the <code>AutoModelForSemanticSegmentation</code> class know that we’re
interested in a custom base model where the decoder head should be randomly initialized using the classes from the custom dataset.`,Zl,te,Il,ae,Gt=`At this point you can check with the <code>print_trainable_parameters</code> helper function that all 100% parameters in the base
model (aka <code>model</code>) are trainable.`,Bl,se,_l,ne,Rt="To leverage the LoRa method, you need to wrap the base model as a <code>PeftModel</code>.  This involves two steps:",vl,ie,Xt="<li>Defining LoRa configuration with <code>LoraConfig</code></li> <li>Wrapping the original <code>model</code> with <code>get_peft_model()</code> using the config defined in the step above.</li>",$l,oe,kl,re,Qt=`Let’s review the <code>LoraConfig</code>. To enable LoRA technique, we must define the target modules within <code>LoraConfig</code> so that
<code>PeftModel</code> can update the necessary matrices. Specifically, we want to target the <code>query</code> and <code>value</code> matrices in the
attention blocks of the base model. These matrices are identified by their respective names, “query” and “value”.
Therefore, we should specify these names in the <code>target_modules</code> argument of <code>LoraConfig</code>.`,Gl,pe,At=`After we wrap our base model <code>model</code> with <code>PeftModel</code> along with the config, we get
a new model where only the LoRA parameters are trainable (so-called “update matrices”) while the pre-trained parameters
are kept frozen. These include the parameters of the randomly initialized classifier parameters too. This is NOT we want
when fine-tuning the base model on our custom dataset. To ensure that the classifier parameters are also trained, we
specify <code>modules_to_save</code>. This also ensures that these modules are serialized alongside the LoRA trainable parameters
when using utilities like <code>save_pretrained()</code> and <code>push_to_hub()</code>.`,Rl,Me,Vt=`In addition to specifying the <code>target_modules</code> within <code>LoraConfig</code>, we also need to specify the <code>modules_to_save</code>. When
we wrap our base model with <code>PeftModel</code> and pass the configuration, we obtain a new model in which only the LoRA parameters
are trainable, while the pre-trained parameters and the randomly initialized classifier parameters are kept frozen.
However, we do want to train the classifier parameters. By specifying the <code>modules_to_save</code> argument, we ensure that the
classifier parameters are also trainable, and they will be serialized alongside the LoRA trainable parameters when we
use utility functions like <code>save_pretrained()</code> and <code>push_to_hub()</code>.`,Xl,me,Yt="Let’s review the rest of the parameters:",Ql,de,xt="<li><code>r</code>: The dimension used by the LoRA update matrices.</li> <li><code>alpha</code>: Scaling factor.</li> <li><code>bias</code>: Specifies if the <code>bias</code> parameters should be trained. <code>None</code> denotes none of the <code>bias</code> parameters will be trained.</li>",Al,ce,Ft=`When all is configured, and the base model is wrapped, the <code>print_trainable_parameters</code> helper function lets us explore
the number of trainable parameters. Since we’re interested in performing <strong>parameter-efficient fine-tuning</strong>,
we should expect to see a lower number of trainable parameters from the <code>lora_model</code> in comparison to the original <code>model</code>
which is indeed the case here.`,Vl,ye,Ht="You can also manually verify what modules are trainable in the <code>lora_model</code>.",Yl,he,xl,ue,St="This confirms that only the LoRA parameters appended to the attention blocks and the <code>decode_head</code> parameters are trainable.",Fl,we,Hl,Je,zt=`Start by defining your training hyperparameters in <code>TrainingArguments</code>. You can change the values of most parameters however
you prefer. Make sure to set <code>remove_unused_columns=False</code>, otherwise the image column will be dropped, and it’s required here.
The only other required parameter is <code>output_dir</code> which specifies where to save your model.
At the end of each epoch, the <code>Trainer</code> will evaluate the IoU metric and save the training checkpoint.`,Sl,be,Nt=`Note that this example is meant to walk you through the workflow when using PEFT for semantic segmentation. We didn’t
perform extensive hyperparameter tuning to achieve optimal results.`,zl,fe,Nl,Ue,Et=`Pass the training arguments to <code>Trainer</code> along with the model, dataset, and <code>compute_metrics</code> function.
Call <code>train()</code> to finetune your model.`,El,Te,Ll,je,ql,ge,Lt=`Use the <code>save_pretrained()</code> method of the <code>lora_model</code> to save the <em>LoRA-only parameters</em> locally.
Alternatively,  use the <code>push_to_hub()</code> method to upload these parameters directly to the Hugging Face Hub
(as shown in the <a href="image_classification_lora">Image classification using LoRA</a> task guide).`,Kl,Ce,Pl,We,qt="We can see that the LoRA-only parameters are just <strong>2.2 MB in size</strong>! This greatly improves the portability when using very large models.",Dl,Ze,Ol,Ie,Kt="Let’s now prepare an <code>inference_model</code> and run inference.",et,Be,lt,_e,Pt="Get an image:",tt,ve,at,J,Dt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-image.png" alt="photo of a room"/>',st,$e,Ot="Preprocess the image to prepare for inference.",nt,ke,it,Ge,ea="Run inference with the encoded image.",ot,Re,rt,Xe,la=`Next, visualize the results.  We need a color palette for this. Here, we use ade_palette(). As it is a long array, so
we don’t include it in this guide, please copy it from <a href="https://github.com/tensorflow/models/blob/3f1ca33afe3c1631b733ea7e40c294273b9e406d/research/deeplab/utils/get_dataset_colormap.py#L51" rel="nofollow">the TensorFlow Model Garden repository</a>.`,pt,Qe,Mt,Ae,ta=`As you can see, the results are far from perfect, however, this example is designed to illustrate the end-to-end workflow of
fine-tuning a semantic segmentation model with LoRa technique, and is not aiming to achieve state-of-the-art
results. The results you see here are the same as you would get if you performed full fine-tuning on the same setup (same
model variant, same dataset, same training schedule, etc.), except LoRA allows to achieve them with a fraction of total
trainable parameters and in less time.`,mt,Ve,aa="If you wish to use this example and improve the results, here are some things that you can try:",dt,Ye,sa='<li>Increase the number of training samples.</li> <li>Try a larger SegFormer model variant (explore available model variants on the <a href="https://huggingface.co/models?search=segformer" rel="nofollow">Hugging Face Hub</a>).</li> <li>Try different values for the arguments available in <code>LoraConfig</code>.</li> <li>Tune the learning rate and batch size.</li>',ct,Fe,yt;return b=new u({props:{title:"Semantic segmentation using LoRA",local:"semantic-segmentation-using-lora",headingTag:"h1"}}),j=new u({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),C=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwZXZhbHVhdGUlMjBkYXRhc2V0cyUyMHBlZnQlMjAtcQ==",highlighted:"!pip install transformers accelerate evaluate datasets peft -q",wrap:!1}}),W=new u({props:{title:"Authenticate to share your model",local:"authenticate-to-share-your-model",headingTag:"h2"}}),I=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),B=new u({props:{title:"Load a dataset",local:"load-a-dataset",headingTag:"h2"}}),v=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc2NlbmVfcGFyc2VfMTUwJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTE1MCU1RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;scene_parse_150&quot;</span>, split=<span class="hljs-string">&quot;train[:150]&quot;</span>)`,wrap:!1}}),k=new h({props:{code:"ZHMlMjAlM0QlMjBkcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMSklMEF0cmFpbl9kcyUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEF0ZXN0X2RzJTIwJTNEJTIwZHMlNUIlMjJ0ZXN0JTIyJTVE",highlighted:`ds = ds.train_test_split(test_size=<span class="hljs-number">0.1</span>)
train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),G=new u({props:{title:"Prepare label maps",local:"prepare-label-maps",headingTag:"h2"}}),Q=new h({props:{code:"aW1wb3J0JTIwanNvbiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjYWNoZWRfZG93bmxvYWQlMkMlMjBoZl9odWJfdXJsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmh1Z2dpbmdmYWNlJTJGbGFiZWwtZmlsZXMlMjIlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMmFkZTIway1pZDJsYWJlbC5qc29uJTIyJTBBaWQybGFiZWwlMjAlM0QlMjBqc29uLmxvYWQob3BlbihjYWNoZWRfZG93bmxvYWQoaGZfaHViX3VybChyZXBvX2lkJTJDJTIwZmlsZW5hbWUlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSklMkMlMjAlMjJyJTIyKSklMEFpZDJsYWJlbCUyMCUzRCUyMCU3QmludChrKSUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCdiUzQSUyMGslMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4oaWQybGFiZWwp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_download, hf_hub_url

repo_id = <span class="hljs-string">&quot;huggingface/label-files&quot;</span>
filename = <span class="hljs-string">&quot;ade20k-id2label.json&quot;</span>
id2label = json.load(<span class="hljs-built_in">open</span>(cached_download(hf_hub_url(repo_id, filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)), <span class="hljs-string">&quot;r&quot;</span>))
id2label = {<span class="hljs-built_in">int</span>(k): v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}
num_labels = <span class="hljs-built_in">len</span>(id2label)`,wrap:!1}}),A=new u({props:{title:"Prepare datasets for training and evaluation",local:"prepare-datasets-for-training-and-evaluation",headingTag:"h2"}}),Y=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJudmlkaWElMkZtaXQtYjAlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBkb19yZWR1Y2VfbGFiZWxzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

checkpoint = <span class="hljs-string">&quot;nvidia/mit-b0&quot;</span>
image_processor = AutoImageProcessor.from_pretrained(checkpoint, do_reduce_labels=<span class="hljs-literal">True</span>)`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb2xvckppdHRlciUwQSUwQWppdHRlciUyMCUzRCUyMENvbG9ySml0dGVyKGJyaWdodG5lc3MlM0QwLjI1JTJDJTIwY29udHJhc3QlM0QwLjI1JTJDJTIwc2F0dXJhdGlvbiUzRDAuMjUlMkMlMjBodWUlM0QwLjEp",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> ColorJitter

jitter = ColorJitter(brightness=<span class="hljs-number">0.25</span>, contrast=<span class="hljs-number">0.25</span>, saturation=<span class="hljs-number">0.25</span>, hue=<span class="hljs-number">0.1</span>)`,wrap:!1}}),S=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwaGFuZGxlX2dyYXlzY2FsZV9pbWFnZShpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBucF9pbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGlmJTIwbnBfaW1hZ2UubmRpbSUyMCUzRCUzRCUyMDIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aWxlZF9pbWFnZSUyMCUzRCUyMG5wLnRpbGUobnAuZXhwYW5kX2RpbXMobnBfaW1hZ2UlMkMlMjAtMSklMkMlMjAzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEltYWdlLmZyb21hcnJheSh0aWxlZF9pbWFnZSklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwSW1hZ2UuZnJvbWFycmF5KG5wX2ltYWdlKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_grayscale_image</span>(<span class="hljs-params">image</span>):
    np_image = np.array(image)
    <span class="hljs-keyword">if</span> np_image.ndim == <span class="hljs-number">2</span>:
        tiled_image = np.tile(np.expand_dims(np_image, -<span class="hljs-number">1</span>), <span class="hljs-number">3</span>)
        <span class="hljs-keyword">return</span> Image.fromarray(tiled_image)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> Image.fromarray(np_image)`,wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBJTBBZGVmJTIwdHJhaW5fdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QmppdHRlcihoYW5kbGVfZ3JheXNjYWxlX2ltYWdlKHgpKSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyYW5ub3RhdGlvbiUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW5wdXRzJTBBJTBBJTBBZGVmJTIwdmFsX3RyYW5zZm9ybXMoZXhhbXBsZV9iYXRjaCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJoYW5kbGVfZ3JheXNjYWxlX2ltYWdlKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwJTVCeCUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVfYmF0Y2glNUIlMjJhbm5vdGF0aW9uJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHM=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image


<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_transforms</span>(<span class="hljs-params">example_batch</span>):
    images = [jitter(handle_grayscale_image(x)) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
    inputs = image_processor(images, labels)
    <span class="hljs-keyword">return</span> inputs


<span class="hljs-keyword">def</span> <span class="hljs-title function_">val_transforms</span>(<span class="hljs-params">example_batch</span>):
    images = [handle_grayscale_image(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    labels = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;annotation&quot;</span>]]
    inputs = image_processor(images, labels)
    <span class="hljs-keyword">return</span> inputs`,wrap:!1}}),L=new h({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybSh0cmFpbl90cmFuc2Zvcm1zKSUwQXRlc3RfZHMuc2V0X3RyYW5zZm9ybSh2YWxfdHJhbnNmb3Jtcyk=",highlighted:`train_ds.set_transform(train_transforms)
test_ds.set_transform(val_transforms)`,wrap:!1}}),q=new u({props:{title:"Create evaluation function",local:"create-evaluation-function",headingTag:"h2"}}),P=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;mean_iou&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        logits, labels = eval_pred
        logits_tensor = torch.from_numpy(logits)
        logits_tensor = nn.functional.interpolate(
            logits_tensor,
            size=labels.shape[-<span class="hljs-number">2</span>:],
            mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
            align_corners=<span class="hljs-literal">False</span>,
        ).argmax(dim=<span class="hljs-number">1</span>)

        pred_labels = logits_tensor.detach().cpu().numpy()
        <span class="hljs-comment"># currently using _compute instead of compute</span>
        <span class="hljs-comment"># see this issue for more info: https://github.com/huggingface/evaluate/pull/328#issuecomment-1286866576</span>
        metrics = metric._compute(
            predictions=pred_labels,
            references=labels,
            num_labels=<span class="hljs-built_in">len</span>(id2label),
            ignore_index=<span class="hljs-number">0</span>,
            reduce_labels=image_processor.do_reduce_labels,
        )

        per_category_accuracy = metrics.pop(<span class="hljs-string">&quot;per_category_accuracy&quot;</span>).tolist()
        per_category_iou = metrics.pop(<span class="hljs-string">&quot;per_category_iou&quot;</span>).tolist()

        metrics.update({<span class="hljs-string">f&quot;accuracy_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_accuracy)})
        metrics.update({<span class="hljs-string">f&quot;iou_<span class="hljs-subst">{id2label[i]}</span>&quot;</span>: v <span class="hljs-keyword">for</span> i, v <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(per_category_iou)})

        <span class="hljs-keyword">return</span> metrics`,wrap:!1}}),D=new u({props:{title:"Load a base model",local:"load-a-base-model",headingTag:"h2"}}),ee=new h({props:{code:"ZGVmJTIwcHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwUHJpbnRzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjB0cmFpbmFibGUlMjBwYXJhbWV0ZXJzJTIwaW4lMjB0aGUlMjBtb2RlbC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjB0cmFpbmFibGVfcGFyYW1zJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMGFsbF9wYXJhbSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjBmb3IlMjBfJTJDJTIwcGFyYW0lMjBpbiUyMG1vZGVsLm5hbWVkX3BhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsbF9wYXJhbSUyMCUyQiUzRCUyMHBhcmFtLm51bWVsKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbmFibGVfcGFyYW1zJTIwJTJCJTNEJTIwcGFyYW0ubnVtZWwoKSUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjAlN0J0cmFpbmFibGVfcGFyYW1zJTdEJTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwJTdCYWxsX3BhcmFtJTdEJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwJTdCMTAwJTIwKiUyMHRyYWluYWJsZV9wYXJhbXMlMjAlMkYlMjBhbGxfcGFyYW0lM0EuMmYlN0QlMjIlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_trainable_parameters</span>(<span class="hljs-params">model</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Prints the number of trainable parameters in the model.
    &quot;&quot;&quot;</span>
    trainable_params = <span class="hljs-number">0</span>
    all_param = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> _, param <span class="hljs-keyword">in</span> model.named_parameters():
        all_param += param.numel()
        <span class="hljs-keyword">if</span> param.requires_grad:
            trainable_params += param.numel()
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;trainable params: <span class="hljs-subst">{trainable_params}</span> || all params: <span class="hljs-subst">{all_param}</span> || trainable%: <span class="hljs-subst">{<span class="hljs-number">100</span> * trainable_params / all_param:<span class="hljs-number">.2</span>f}</span>&quot;</span>
    )`,wrap:!1}}),te=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMjBsYWJlbDJpZCUzRGxhYmVsMmlkJTJDJTIwaWdub3JlX21pc21hdGNoZWRfc2l6ZXMlM0RUcnVlJTBBKSUwQXByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSemanticSegmentation, TrainingArguments, Trainer

model = AutoModelForSemanticSegmentation.from_pretrained(
    checkpoint, id2label=id2label, label2id=label2id, ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)
print_trainable_parameters(model)`,wrap:!1}}),se=new u({props:{title:"Wrap the base model as a PeftModel for LoRA training",local:"wrap-the-base-model-as-a-peftmodel-for-lora-training",headingTag:"h2"}}),oe=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJsb3JhX29ubHklMjIlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJkZWNvZGVfaGVhZCUyMiU1RCUyQyUwQSklMEFsb3JhX21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMobG9yYV9tb2RlbCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">32</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;lora_only&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;decode_head&quot;</span>],
)
lora_model = get_peft_model(model, config)
print_trainable_parameters(lora_model)`,wrap:!1}}),he=new h({props:{code:"Zm9yJTIwbmFtZSUyQyUyMHBhcmFtJTIwaW4lMjBsb3JhX21vZGVsLm5hbWVkX3BhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KG5hbWUlMkMlMjBwYXJhbS5zaGFwZSk=",highlighted:`<span class="hljs-keyword">for</span> name, param <span class="hljs-keyword">in</span> lora_model.named_parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        <span class="hljs-built_in">print</span>(name, param.shape)`,wrap:!1}}),we=new u({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),fe=new h({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMGNoZWNrcG9pbnQuc3BsaXQoJTIyJTJGJTIyKSU1Qi0xJTVEJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RmJTIyJTdCbW9kZWxfbmFtZSU3RC1zY2VuZS1wYXJzZS0xNTAtbG9yYSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS00JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfdG90YWxfbGltaXQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBKQ==",highlighted:`model_name = checkpoint.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-scene-parse-150-lora&quot;</span>,
    learning_rate=<span class="hljs-number">5e-4</span>,
    num_train_epochs=<span class="hljs-number">50</span>,
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_total_limit=<span class="hljs-number">3</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    logging_steps=<span class="hljs-number">5</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),Te=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rsb3JhX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZHMlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0ZXN0X2RzJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer = Trainer(
    model=lora_model,
    args=training_args,
    train_dataset=train_ds,
    eval_dataset=test_ds,
    compute_metrics=compute_metrics,
)

trainer.train()`,wrap:!1}}),je=new u({props:{title:"Save the model and run inference",local:"save-the-model-and-run-inference",headingTag:"h2"}}),Ce=new h({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJzZWdmb3JtZXItc2NlbmUtcGFyc2UtMTUwLWxvcmElMjIlMEFsb3JhX21vZGVsLnNhdmVfcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`model_id = <span class="hljs-string">&quot;segformer-scene-parse-150-lora&quot;</span>
lora_model.save_pretrained(model_id)`,wrap:!1}}),Ze=new h({props:{code:"IWxzJTIwLWxoJTIwJTdCbW9kZWxfaWQlN0QlMEF0b3RhbCUyMDIuMk0lMEEtcnctci0tci0tJTIwMSUyMHJvb3QlMjByb290JTIwJTIwMzY5JTIwRmViJTIwJTIwOCUyMDAzJTNBMDklMjBhZGFwdGVyX2NvbmZpZy5qc29uJTBBLXJ3LXItLXItLSUyMDElMjByb290JTIwcm9vdCUyMDIuMk0lMjBGZWIlMjAlMjA4JTIwMDMlM0EwOSUyMGFkYXB0ZXJfbW9kZWwuYmlu",highlighted:`!<span class="hljs-built_in">ls</span> -lh {model_id}
total 2.2M
-rw-r--r-- 1 root root  369 Feb  8 03:09 adapter_config.json
-rw-r--r-- 1 root root 2.2M Feb  8 03:09 adapter_model.bin`,wrap:!1}}),Be=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMjBsYWJlbDJpZCUzRGxhYmVsMmlkJTJDJTIwaWdub3JlX21pc21hdGNoZWRfc2l6ZXMlM0RUcnVlJTBBKSUwQSUwQWluZmVyZW5jZV9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWwlMkMlMjBtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig

config = PeftConfig.from_pretrained(model_id)
model = AutoModelForSemanticSegmentation.from_pretrained(
    checkpoint, id2label=id2label, label2id=label2id, ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)

inference_model = PeftModel.from_pretrained(model, model_id)`,wrap:!1}}),ve=new h({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZzZW1hbnRpYy1zZWctaW1hZ2UucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/semantic-seg-image.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),ke=new h({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Re=new h({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBpbmZlcmVuY2VfbW9kZWwocGl4ZWxfdmFsdWVzJTNEZW5jb2RpbmcucGl4ZWxfdmFsdWVzKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBdXBzYW1wbGVkX2xvZ2l0cyUyMCUzRCUyMG5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwbG9naXRzJTJDJTBBJTIwJTIwJTIwJTIwc2l6ZSUzRGltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGUlM0QlMjJiaWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEFwcmVkX3NlZyUyMCUzRCUyMHVwc2FtcGxlZF9sb2dpdHMuYXJnbWF4KGRpbSUzRDEpJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = inference_model(pixel_values=encoding.pixel_values)
    logits = outputs.logits

upsampled_logits = nn.functional.interpolate(
    logits,
    size=image.size[::-<span class="hljs-number">1</span>],
    mode=<span class="hljs-string">&quot;bilinear&quot;</span>,
    align_corners=<span class="hljs-literal">False</span>,
)

pred_seg = upsampled_logits.argmax(dim=<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),Qe=new h({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWNvbG9yX3NlZyUyMCUzRCUyMG5wLnplcm9zKChwcmVkX3NlZy5zaGFwZSU1QjAlNUQlMkMlMjBwcmVkX3NlZy5zaGFwZSU1QjElNUQlMkMlMjAzKSUyQyUyMGR0eXBlJTNEbnAudWludDgpJTBBcGFsZXR0ZSUyMCUzRCUyMG5wLmFycmF5KGFkZV9wYWxldHRlKCkpJTBBJTBBZm9yJTIwbGFiZWwlMkMlMjBjb2xvciUyMGluJTIwZW51bWVyYXRlKHBhbGV0dGUpJTNBJTBBJTIwJTIwJTIwJTIwY29sb3Jfc2VnJTVCcHJlZF9zZWclMjAlM0QlM0QlMjBsYWJlbCUyQyUyMCUzQSU1RCUyMCUzRCUyMGNvbG9yJTBBY29sb3Jfc2VnJTIwJTNEJTIwY29sb3Jfc2VnJTVCLi4uJTJDJTIwJTNBJTNBLTElNUQlMjAlMjAlMjMlMjBjb252ZXJ0JTIwdG8lMjBCR1IlMEElMEFpbWclMjAlM0QlMjBucC5hcnJheShpbWFnZSklMjAqJTIwMC41JTIwJTJCJTIwY29sb3Jfc2VnJTIwKiUyMDAuNSUyMCUyMCUyMyUyMHBsb3QlMjB0aGUlMjBpbWFnZSUyMHdpdGglMjB0aGUlMjBzZWdtZW50YXRpb24lMjBtYXAlMEFpbWclMjAlM0QlMjBpbWcuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQXBsdC5maWd1cmUoZmlnc2l6ZSUzRCgxNSUyQyUyMDEwKSklMEFwbHQuaW1zaG93KGltZyklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

color_seg = np.zeros((pred_seg.shape[<span class="hljs-number">0</span>], pred_seg.shape[<span class="hljs-number">1</span>], <span class="hljs-number">3</span>), dtype=np.uint8)
palette = np.array(ade_palette())

<span class="hljs-keyword">for</span> label, color <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(palette):
    color_seg[pred_seg == label, :] = color
color_seg = color_seg[..., ::-<span class="hljs-number">1</span>]  <span class="hljs-comment"># convert to BGR</span>

img = np.array(image) * <span class="hljs-number">0.5</span> + color_seg * <span class="hljs-number">0.5</span>  <span class="hljs-comment"># plot the image with the segmentation map</span>
img = img.astype(np.uint8)

plt.figure(figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">10</span>))
plt.imshow(img)
plt.show()`,wrap:!1}}),{c(){w=i("meta"),He=s(),xe=i("p"),Se=s(),p(b.$$.fragment),ze=s(),f=i("p"),f.textContent=wt,Ne=s(),U=i("p"),U.textContent=Jt,Ee=s(),T=i("p"),T.innerHTML=bt,Le=s(),p(j.$$.fragment),qe=s(),g=i("p"),g.textContent=ft,Ke=s(),p(C.$$.fragment),Pe=s(),p(W.$$.fragment),De=s(),Z=i("p"),Z.innerHTML=Ut,Oe=s(),p(I.$$.fragment),el=s(),p(B.$$.fragment),ll=s(),_=i("p"),_.innerHTML=Tt,tl=s(),p(v.$$.fragment),al=s(),$=i("p"),$.textContent=jt,sl=s(),p(k.$$.fragment),nl=s(),p(G.$$.fragment),il=s(),R=i("p"),R.textContent=gt,ol=s(),X=i("ul"),X.innerHTML=Ct,rl=s(),p(Q.$$.fragment),pl=s(),p(A.$$.fragment),Ml=s(),V=i("p"),V.innerHTML=Wt,ml=s(),p(Y.$$.fragment),dl=s(),x=i("p"),x.innerHTML=Zt,cl=s(),p(F.$$.fragment),yl=s(),H=i("p"),H.innerHTML=It,hl=s(),p(S.$$.fragment),ul=s(),z=i("p"),z.textContent=Bt,wl=s(),p(N.$$.fragment),Jl=s(),E=i("p"),E.innerHTML=_t,bl=s(),p(L.$$.fragment),fl=s(),p(q.$$.fragment),Ul=s(),K=i("p"),K.innerHTML=vt,Tl=s(),p(P.$$.fragment),jl=s(),p(D.$$.fragment),gl=s(),O=i("p"),O.textContent=$t,Cl=s(),p(ee.$$.fragment),Wl=s(),le=i("p"),le.innerHTML=kt,Zl=s(),p(te.$$.fragment),Il=s(),ae=i("p"),ae.innerHTML=Gt,Bl=s(),p(se.$$.fragment),_l=s(),ne=i("p"),ne.innerHTML=Rt,vl=s(),ie=i("ol"),ie.innerHTML=Xt,$l=s(),p(oe.$$.fragment),kl=s(),re=i("p"),re.innerHTML=Qt,Gl=s(),pe=i("p"),pe.innerHTML=At,Rl=s(),Me=i("p"),Me.innerHTML=Vt,Xl=s(),me=i("p"),me.textContent=Yt,Ql=s(),de=i("ul"),de.innerHTML=xt,Al=s(),ce=i("p"),ce.innerHTML=Ft,Vl=s(),ye=i("p"),ye.innerHTML=Ht,Yl=s(),p(he.$$.fragment),xl=s(),ue=i("p"),ue.innerHTML=St,Fl=s(),p(we.$$.fragment),Hl=s(),Je=i("p"),Je.innerHTML=zt,Sl=s(),be=i("p"),be.textContent=Nt,zl=s(),p(fe.$$.fragment),Nl=s(),Ue=i("p"),Ue.innerHTML=Et,El=s(),p(Te.$$.fragment),Ll=s(),p(je.$$.fragment),ql=s(),ge=i("p"),ge.innerHTML=Lt,Kl=s(),p(Ce.$$.fragment),Pl=s(),We=i("p"),We.innerHTML=qt,Dl=s(),p(Ze.$$.fragment),Ol=s(),Ie=i("p"),Ie.innerHTML=Kt,et=s(),p(Be.$$.fragment),lt=s(),_e=i("p"),_e.textContent=Pt,tt=s(),p(ve.$$.fragment),at=s(),J=i("div"),J.innerHTML=Dt,st=s(),$e=i("p"),$e.textContent=Ot,nt=s(),p(ke.$$.fragment),it=s(),Ge=i("p"),Ge.textContent=ea,ot=s(),p(Re.$$.fragment),rt=s(),Xe=i("p"),Xe.innerHTML=la,pt=s(),p(Qe.$$.fragment),Mt=s(),Ae=i("p"),Ae.textContent=ta,mt=s(),Ve=i("p"),Ve.textContent=aa,dt=s(),Ye=i("ul"),Ye.innerHTML=sa,ct=s(),Fe=i("p"),this.h()},l(e){const l=ma("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(t),He=n(e),xe=o(e,"P",{}),na(xe).forEach(t),Se=n(e),M(b.$$.fragment,e),ze=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-ptgpdg"&&(f.textContent=wt),Ne=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1q529js"&&(U.textContent=Jt),Ee=n(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-e5fkf5"&&(T.innerHTML=bt),Le=n(e),M(j.$$.fragment,e),qe=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1hz22x2"&&(g.textContent=ft),Ke=n(e),M(C.$$.fragment,e),Pe=n(e),M(W.$$.fragment,e),De=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1t4proi"&&(Z.innerHTML=Ut),Oe=n(e),M(I.$$.fragment,e),el=n(e),M(B.$$.fragment,e),ll=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1w5yso9"&&(_.innerHTML=Tt),tl=n(e),M(v.$$.fragment,e),al=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1d7ffhy"&&($.textContent=jt),sl=n(e),M(k.$$.fragment,e),nl=n(e),M(G.$$.fragment,e),il=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-getpmi"&&(R.textContent=gt),ol=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-phg2cz"&&(X.innerHTML=Ct),rl=n(e),M(Q.$$.fragment,e),pl=n(e),M(A.$$.fragment,e),Ml=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-x8866f"&&(V.innerHTML=Wt),ml=n(e),M(Y.$$.fragment,e),dl=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-fe2rtc"&&(x.innerHTML=Zt),cl=n(e),M(F.$$.fragment,e),yl=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-vm1b9v"&&(H.innerHTML=It),hl=n(e),M(S.$$.fragment,e),ul=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-yxifz1"&&(z.textContent=Bt),wl=n(e),M(N.$$.fragment,e),Jl=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-sagovx"&&(E.innerHTML=_t),bl=n(e),M(L.$$.fragment,e),fl=n(e),M(q.$$.fragment,e),Ul=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1x2616c"&&(K.innerHTML=vt),Tl=n(e),M(P.$$.fragment,e),jl=n(e),M(D.$$.fragment,e),gl=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-z7c6p7"&&(O.textContent=$t),Cl=n(e),M(ee.$$.fragment,e),Wl=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-134egv8"&&(le.innerHTML=kt),Zl=n(e),M(te.$$.fragment,e),Il=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1hyd5lx"&&(ae.innerHTML=Gt),Bl=n(e),M(se.$$.fragment,e),_l=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-h2ilia"&&(ne.innerHTML=Rt),vl=n(e),ie=o(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-gdfjac"&&(ie.innerHTML=Xt),$l=n(e),M(oe.$$.fragment,e),kl=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1dir0x5"&&(re.innerHTML=Qt),Gl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-l3bbz"&&(pe.innerHTML=At),Rl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1coy915"&&(Me.innerHTML=Vt),Xl=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-ss5ia"&&(me.textContent=Yt),Ql=n(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1m2rv79"&&(de.innerHTML=xt),Al=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-10wmx8i"&&(ce.innerHTML=Ft),Vl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1o171ky"&&(ye.innerHTML=Ht),Yl=n(e),M(he.$$.fragment,e),xl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1g7xqd2"&&(ue.innerHTML=St),Fl=n(e),M(we.$$.fragment,e),Hl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-sicdsw"&&(Je.innerHTML=zt),Sl=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-sj51v2"&&(be.textContent=Nt),zl=n(e),M(fe.$$.fragment,e),Nl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-nimjtw"&&(Ue.innerHTML=Et),El=n(e),M(Te.$$.fragment,e),Ll=n(e),M(je.$$.fragment,e),ql=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-wzzfy"&&(ge.innerHTML=Lt),Kl=n(e),M(Ce.$$.fragment,e),Pl=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-8jrf93"&&(We.innerHTML=qt),Dl=n(e),M(Ze.$$.fragment,e),Ol=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1ws2x6q"&&(Ie.innerHTML=Kt),et=n(e),M(Be.$$.fragment,e),lt=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1k70j7o"&&(_e.textContent=Pt),tt=n(e),M(ve.$$.fragment,e),at=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-runw56"&&(J.innerHTML=Dt),st=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1a29ol4"&&($e.textContent=Ot),nt=n(e),M(ke.$$.fragment,e),it=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-k2a84"&&(Ge.textContent=ea),ot=n(e),M(Re.$$.fragment,e),rt=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-paeq5"&&(Xe.innerHTML=la),pt=n(e),M(Qe.$$.fragment,e),Mt=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1rbxn15"&&(Ae.textContent=ta),mt=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1bj2ejn"&&(Ve.textContent=aa),dt=n(e),Ye=o(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-1herdxp"&&(Ye.innerHTML=sa),ct=n(e),Fe=o(e,"P",{}),na(Fe).forEach(t),this.h()},h(){ht(w,"name","hf:doc:metadata"),ht(w,"content",ha),ht(J,"class","flex justify-center")},m(e,l){da(document.head,w),a(e,He,l),a(e,xe,l),a(e,Se,l),m(b,e,l),a(e,ze,l),a(e,f,l),a(e,Ne,l),a(e,U,l),a(e,Ee,l),a(e,T,l),a(e,Le,l),m(j,e,l),a(e,qe,l),a(e,g,l),a(e,Ke,l),m(C,e,l),a(e,Pe,l),m(W,e,l),a(e,De,l),a(e,Z,l),a(e,Oe,l),m(I,e,l),a(e,el,l),m(B,e,l),a(e,ll,l),a(e,_,l),a(e,tl,l),m(v,e,l),a(e,al,l),a(e,$,l),a(e,sl,l),m(k,e,l),a(e,nl,l),m(G,e,l),a(e,il,l),a(e,R,l),a(e,ol,l),a(e,X,l),a(e,rl,l),m(Q,e,l),a(e,pl,l),m(A,e,l),a(e,Ml,l),a(e,V,l),a(e,ml,l),m(Y,e,l),a(e,dl,l),a(e,x,l),a(e,cl,l),m(F,e,l),a(e,yl,l),a(e,H,l),a(e,hl,l),m(S,e,l),a(e,ul,l),a(e,z,l),a(e,wl,l),m(N,e,l),a(e,Jl,l),a(e,E,l),a(e,bl,l),m(L,e,l),a(e,fl,l),m(q,e,l),a(e,Ul,l),a(e,K,l),a(e,Tl,l),m(P,e,l),a(e,jl,l),m(D,e,l),a(e,gl,l),a(e,O,l),a(e,Cl,l),m(ee,e,l),a(e,Wl,l),a(e,le,l),a(e,Zl,l),m(te,e,l),a(e,Il,l),a(e,ae,l),a(e,Bl,l),m(se,e,l),a(e,_l,l),a(e,ne,l),a(e,vl,l),a(e,ie,l),a(e,$l,l),m(oe,e,l),a(e,kl,l),a(e,re,l),a(e,Gl,l),a(e,pe,l),a(e,Rl,l),a(e,Me,l),a(e,Xl,l),a(e,me,l),a(e,Ql,l),a(e,de,l),a(e,Al,l),a(e,ce,l),a(e,Vl,l),a(e,ye,l),a(e,Yl,l),m(he,e,l),a(e,xl,l),a(e,ue,l),a(e,Fl,l),m(we,e,l),a(e,Hl,l),a(e,Je,l),a(e,Sl,l),a(e,be,l),a(e,zl,l),m(fe,e,l),a(e,Nl,l),a(e,Ue,l),a(e,El,l),m(Te,e,l),a(e,Ll,l),m(je,e,l),a(e,ql,l),a(e,ge,l),a(e,Kl,l),m(Ce,e,l),a(e,Pl,l),a(e,We,l),a(e,Dl,l),m(Ze,e,l),a(e,Ol,l),a(e,Ie,l),a(e,et,l),m(Be,e,l),a(e,lt,l),a(e,_e,l),a(e,tt,l),m(ve,e,l),a(e,at,l),a(e,J,l),a(e,st,l),a(e,$e,l),a(e,nt,l),m(ke,e,l),a(e,it,l),a(e,Ge,l),a(e,ot,l),m(Re,e,l),a(e,rt,l),a(e,Xe,l),a(e,pt,l),m(Qe,e,l),a(e,Mt,l),a(e,Ae,l),a(e,mt,l),a(e,Ve,l),a(e,dt,l),a(e,Ye,l),a(e,ct,l),a(e,Fe,l),yt=!0},p:oa,i(e){yt||(d(b.$$.fragment,e),d(j.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(I.$$.fragment,e),d(B.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(Y.$$.fragment,e),d(F.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(oe.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d(fe.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(Ce.$$.fragment,e),d(Ze.$$.fragment,e),d(Be.$$.fragment,e),d(ve.$$.fragment,e),d(ke.$$.fragment,e),d(Re.$$.fragment,e),d(Qe.$$.fragment,e),yt=!0)},o(e){c(b.$$.fragment,e),c(j.$$.fragment,e),c(C.$$.fragment,e),c(W.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(G.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(S.$$.fragment,e),c(N.$$.fragment,e),c(L.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(oe.$$.fragment,e),c(he.$$.fragment,e),c(we.$$.fragment,e),c(fe.$$.fragment,e),c(Te.$$.fragment,e),c(je.$$.fragment,e),c(Ce.$$.fragment,e),c(Ze.$$.fragment,e),c(Be.$$.fragment,e),c(ve.$$.fragment,e),c(ke.$$.fragment,e),c(Re.$$.fragment,e),c(Qe.$$.fragment,e),yt=!1},d(e){e&&(t(He),t(xe),t(Se),t(ze),t(f),t(Ne),t(U),t(Ee),t(T),t(Le),t(qe),t(g),t(Ke),t(Pe),t(De),t(Z),t(Oe),t(el),t(ll),t(_),t(tl),t(al),t($),t(sl),t(nl),t(il),t(R),t(ol),t(X),t(rl),t(pl),t(Ml),t(V),t(ml),t(dl),t(x),t(cl),t(yl),t(H),t(hl),t(ul),t(z),t(wl),t(Jl),t(E),t(bl),t(fl),t(Ul),t(K),t(Tl),t(jl),t(gl),t(O),t(Cl),t(Wl),t(le),t(Zl),t(Il),t(ae),t(Bl),t(_l),t(ne),t(vl),t(ie),t($l),t(kl),t(re),t(Gl),t(pe),t(Rl),t(Me),t(Xl),t(me),t(Ql),t(de),t(Al),t(ce),t(Vl),t(ye),t(Yl),t(xl),t(ue),t(Fl),t(Hl),t(Je),t(Sl),t(be),t(zl),t(Nl),t(Ue),t(El),t(Ll),t(ql),t(ge),t(Kl),t(Pl),t(We),t(Dl),t(Ol),t(Ie),t(et),t(lt),t(_e),t(tt),t(at),t(J),t(st),t($e),t(nt),t(it),t(Ge),t(ot),t(rt),t(Xe),t(pt),t(Mt),t(Ae),t(mt),t(Ve),t(dt),t(Ye),t(ct),t(Fe)),t(w),y(b,e),y(j,e),y(C,e),y(W,e),y(I,e),y(B,e),y(v,e),y(k,e),y(G,e),y(Q,e),y(A,e),y(Y,e),y(F,e),y(S,e),y(N,e),y(L,e),y(q,e),y(P,e),y(D,e),y(ee,e),y(te,e),y(se,e),y(oe,e),y(he,e),y(we,e),y(fe,e),y(Te,e),y(je,e),y(Ce,e),y(Ze,e),y(Be,e),y(ve,e),y(ke,e),y(Re,e),y(Qe,e)}}}const ha='{"title":"Semantic segmentation using LoRA","local":"semantic-segmentation-using-lora","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Authenticate to share your model","local":"authenticate-to-share-your-model","sections":[],"depth":2},{"title":"Load a dataset","local":"load-a-dataset","sections":[],"depth":2},{"title":"Prepare label maps","local":"prepare-label-maps","sections":[],"depth":2},{"title":"Prepare datasets for training and evaluation","local":"prepare-datasets-for-training-and-evaluation","sections":[],"depth":2},{"title":"Create evaluation function","local":"create-evaluation-function","sections":[],"depth":2},{"title":"Load a base model","local":"load-a-base-model","sections":[],"depth":2},{"title":"Wrap the base model as a PeftModel for LoRA training","local":"wrap-the-base-model-as-a-peftmodel-for-lora-training","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Save the model and run inference","local":"save-the-model-and-run-inference","sections":[],"depth":2}],"depth":1}';function ua(ut){return ra(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ca}),[]}class Ua extends pa{constructor(w){super(),Ma(this,w,ua,ya,ia,{})}}export{Ua as component};
