import{s as Kl,o as Ol,n as Pl}from"../chunks/scheduler.c59d9fbb.js";import{S as es,i as ls,g as i,s as n,r as c,A as ss,h as M,f as s,c as a,j as Dl,u as p,x as r,k as Te,y as ts,a as t,v as d,d as y,t as m,w as J}from"../chunks/index.a47918e3.js";import{H as ue,g as ns}from"../chunks/Heading.fb623c98.js";import{T as ql}from"../chunks/Tip.3fcf4aa4.js";import{C as u}from"../chunks/CodeBlock.936db8cd.js";function as(he){let o,h='💡 Read <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">LoRA: Low-Rank Adaptation of Large Language Models</a> to learn more about LoRA.';return{c(){o=i("p"),o.innerHTML=h},l(T){o=M(T,"P",{"data-svelte-h":!0}),r(o)!=="svelte-kt6e6m"&&(o.innerHTML=h)},m(T,w){t(T,o,w)},p:Pl,d(T){T&&s(o)}}}function is(he){let o,h="It is assumed that PyTorch with CUDA support is already installed.";return{c(){o=i("p"),o.textContent=h},l(T){o=M(T,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1m5ogeb"&&(o.textContent=h)},m(T,w){t(T,o,w)},p:Pl,d(T){T&&s(o)}}}function Ms(he){let o,h,T,w,C,Ue,W,ul="Low-Rank Adaptation (LoRA) is a reparametrization method that aims to reduce the number of trainable parameters with low-rank representations. The weight matrix is broken down into low-rank matrices that are trained and updated. All the pretrained model parameters remain frozen. After training, the low-rank matrices are added back to the original weights. This makes it more efficient to store and train a LoRA model because there are significantly fewer parameters.",be,U,je,B,hl='In this guide, we’ll be using a LoRA <a href="https://github.com/huggingface/peft/tree/main/examples/lora_dreambooth" rel="nofollow">script</a> to fine-tune a <a href="https://huggingface.co/intfloat/e5-large-v2" rel="nofollow"><code>intfloat/e5-large-v2</code></a> model on the <a href="https://huggingface.co/datasets/smangrul/amazon_esci" rel="nofollow"><code>smangrul/amazon_esci</code></a> dataset for semantic similarity tasks. Feel free to explore the script to learn how things work in greater detail!',fe,_,Ie,k,wl='Start by installing 🤗 PEFT from <a href="https://github.com/huggingface/peft" rel="nofollow">source</a>, and then navigate to the directory containing the training scripts for fine-tuning DreamBooth with LoRA:',Ze,V,ge,G,Ul="Install all the necessary required libraries with:",Ce,R,We,X,bl="Next, import all the necessary libraries:",Be,v,jl="<li>🤗 Transformers for loading the <code>intfloat/e5-large-v2</code> model and tokenizer</li> <li>🤗 Accelerate for the training loop</li> <li>🤗 Datasets for loading and preparing the <code>smangrul/amazon_esci</code> dataset for training and inference</li> <li>🤗 Evaluate for evaluating the model’s performance</li> <li>🤗 PEFT for setting up the LoRA configuration and creating the PEFT model</li> <li>🤗 huggingface_hub for uploading the trained model to HF hub</li> <li>hnswlib for creating the search index and doing fast approximate nearest neighbor search</li>",_e,b,ke,N,Ve,x,fl="Launch the training script with <code>accelerate launch</code> and pass your hyperparameters along with the <code>--use_peft</code> argument to enable LoRA.",Ge,A,Il='This guide uses the following <a href="/docs/peft/main/en/package_reference/tuners#peft.LoraConfig">LoraConfig</a>:',Re,E,Xe,Y,Zl="Here’s what a full set of script arguments may look like when running in Colab on a V100 GPU with standard RAM:",ve,z,Ne,F,xe,S,gl=`The dataset we’ll be using is a small subset of the <a href="https://github.com/amazon-science/esci-data.git" rel="nofollow">esci-data</a> dataset (it can be found on Hub at <a href="https://huggingface.co/datasets/smangrul/amazon_esci" rel="nofollow">smangrul/amazon_esci</a>).
Each sample contains a tuple of <code>(query, product_title, relevance_label)</code> where <code>relevance_label</code> is <code>1</code> if the product matches the intent of the <code>query</code>, otherwise it is <code>0</code>.`,Ae,Q,Cl=`Our task is to build an embedding model that can retrieve semantically similar products given a product query.
This is usually the first stage in building a product search engine to retrieve all the potentially relevant products of a given query.
Typically, this involves using Bi-Encoder models to cross-join the query and millions of products which could blow up quickly.
Instead, you can use a Transformer model to retrieve the top K nearest similar products for a given query by
embedding the query and products in the same latent embedding space.
The millions of products are embedded offline to create a search index.
At run time, only the query is embedded by the model, and products are retrieved from the search index with a<br/>
fast approximate nearest neighbor search library such as <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a> or <a href="https://github.com/nmslib/hnswlib" rel="nofollow">HNSWlib</a>.`,Ee,H,Wl=`The next stage involves reranking the retrieved list of products to return the most relevant ones;
this stage can utilize cross-encoder based models as the cross-join between the query and a limited set of retrieved products.
The diagram below from <a href="https://github.com/rom1504/awesome-semantic-search" rel="nofollow">awesome-semantic-search</a> outlines a rough semantic search pipeline:`,Ye,j,Bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/semantic_search_pipeline.png" alt="Semantic Search Pipeline"/>',ze,$,_l=`For this task guide, we will explore the first stage of training an embedding model to predict semantically similar products
given a product query.`,Fe,L,Se,D,kl='We finetune <a href="https://huggingface.co/intfloat/e5-large-v2" rel="nofollow">e5-large-v2</a> which tops the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB benchmark</a> using PEFT-LoRA.',Qe,q,Vl="<code>AutoModelForSentenceEmbedding</code> returns the query and product embeddings, and the <code>mean_pooling</code> function pools them across the sequence dimension and normalizes them:",He,P,$e,K,Gl="The <code>get_cosine_embeddings</code> function computes the cosine similarity and the <code>get_loss</code> function computes the loss. The loss enables the model to learn that a cosine score of <code>1</code> for query and product pairs is relevant, and a cosine score of <code>0</code> or below is irrelevant.",Le,O,Rl='Define the <a href="/docs/peft/main/en/package_reference/config#peft.PeftConfig">PeftConfig</a> with your LoRA hyperparameters, and create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. We use 🤗 Accelerate for handling all device management, mixed precision training, gradient accumulation, WandB tracking, and saving/loading utilities.',De,ee,qe,le,Xl="The table below compares the training time, the batch size that could be fit in Colab, and the best ROC-AUC scores between a PEFT model and a fully fine-tuned model:",Pe,se,vl="<thead><tr><th>Training Type</th> <th>Training time per epoch (Hrs)</th> <th>Batch Size that fits</th> <th>ROC-AUC score (higher is better)</th></tr></thead> <tbody><tr><td>Pre-Trained e5-large-v2</td> <td>-</td> <td>-</td> <td>0.68</td></tr> <tr><td>PEFT</td> <td>1.73</td> <td>64</td> <td>0.787</td></tr> <tr><td>Full Fine-Tuning</td> <td>2.33</td> <td>32</td> <td>0.7969</td></tr></tbody>",Ke,te,Nl=`The PEFT-LoRA model trains <strong>1.35X</strong> faster and can fit <strong>2X</strong> batch size compared to the fully fine-tuned model, and the performance of PEFT-LoRA is comparable to the fully fine-tuned model with a relative drop of <strong>-1.24%</strong> in ROC-AUC. This gap can probably be closed with bigger models as mentioned in <a href="https://huggingface.co/papers/2104.08691" rel="nofollow">The Power of Scale for Parameter-Efficient Prompt Tuning
</a>.`,Oe,ne,el,ae,xl=`Let’s go! Now we have the model, we need to create a search index of all the products in our catalog.
Please refer to <code>peft_lora_embedding_semantic_similarity_inference.ipynb</code> for the complete inference code.`,ll,ie,Al="<li>Get a list of ids to products which we can call <code>ids_to_products_dict</code>:</li>",sl,Me,tl,f,El='<li>Use the trained <a href="https://huggingface.co/smangrul/peft_lora_e5_ecommerce_semantic_search_colab" rel="nofollow">smangrul/peft_lora_e5_ecommerce_semantic_search_colab</a> model to get the product embeddings:</li>',nl,re,al,I,Yl="<li>Create a search index using HNSWlib:</li>",il,oe,Ml,Z,zl="<li>Get the query embeddings and nearest neighbors:</li>",rl,ce,ol,g,Fl="<li>Let’s test it out with the query <code>deep learning books</code>:</li>",cl,pe,pl,de,Sl="Output:",dl,ye,yl,me,Ql="Books on deep learning and machine learning are retrieved even though <code>machine learning</code> wasn’t included in the query. This means the model has learned that these books are semantically relevant to the query based on the purchase behavior of customers on Amazon.",ml,Je,Hl='The next steps would ideally involve using ONNX/TensorRT to optimize the model and using a Triton server to host it. Check out 🤗 <a href="https://huggingface.co/docs/optimum/index" rel="nofollow">Optimum</a> for related optimizations for efficient serving!',Jl,we,Tl;return C=new ue({props:{title:"LoRA for semantic similarity tasks",local:"lora-for-semantic-similarity-tasks",headingTag:"h1"}}),U=new ql({props:{$$slots:{default:[as]},$$scope:{ctx:he}}}),_=new ue({props:{title:"Setup",local:"setup",headingTag:"h2"}}),V=new u({props:{code:"Y2QlMjBwZWZ0JTJGZXhhbXBsZXMlMkZmZWF0dXJlX2V4dHJhY3Rpb24=",highlighted:'<span class="hljs-built_in">cd</span> peft/examples/feature_extraction',wrap:!1}}),R=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:"pip install -r requirements.txt",wrap:!1}}),b=new ql({props:{$$slots:{default:[is]},$$scope:{ctx:he}}}),N=new ue({props:{title:"Train",local:"train",headingTag:"h2"}}),E=new u({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0RUYXNrVHlwZS5GRUFUVVJFX0VYVFJBQ1RJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmtleSUyMiUyQyUyMCUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`peft_config = LoraConfig(
            r=<span class="hljs-number">8</span>,
            lora_alpha=<span class="hljs-number">16</span>,
            bias=<span class="hljs-string">&quot;none&quot;</span>,
            task_type=TaskType.FEATURE_EXTRACTION,
            target_modules=[<span class="hljs-string">&quot;key&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
        )`,wrap:!1}}),z=new u({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCU1QyUwQS0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCU1QyUwQXBlZnRfbG9yYV9lbWJlZGRpbmdfc2VtYW50aWNfc2VhcmNoLnB5JTIwJTVDJTBBLS1kYXRhc2V0X25hbWUlM0QlMjJzbWFuZ3J1bCUyRmFtYXpvbl9lc2NpJTIyJTIwJTVDJTBBLS1tYXhfbGVuZ3RoJTNENzAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmludGZsb2F0JTJGZTUtbGFyZ2UtdjIlMjIlMjAlNUMlMEEtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDY0JTIwJTVDJTBBLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDEyOCUyMCU1QyUwQS0tbGVhcm5pbmdfcmF0ZSUzRDVlLTQlMjAlNUMlMEEtLXdlaWdodF9kZWNheSUzRDAuMCUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEEtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMjAlNUMlMEEtLW91dHB1dF9kaXIlM0QlMjJyZXN1bHRzJTJGcGVmdF9sb3JhX2U1X2Vjb21tZXJjZV9zZW1hbnRpY19zZWFyY2hfY29sYWIlMjIlMjAlNUMlMEEtLXNlZWQlM0Q0MiUyMCU1QyUwQS0tcHVzaF90b19odWIlMjAlNUMlMEEtLWh1Yl9tb2RlbF9pZCUzRCUyMnNtYW5ncnVsJTJGcGVmdF9sb3JhX2U1X2Vjb21tZXJjZV9zZW1hbnRpY19zZWFyY2hfY29sYWIlMjIlMjAlNUMlMEEtLXdpdGhfdHJhY2tpbmclMjAlNUMlMEEtLXJlcG9ydF90byUzRCUyMndhbmRiJTIyJTIwJTVDJTBBLS11c2VfcGVmdCUyMCU1QyUwQS0tY2hlY2twb2ludGluZ19zdGVwcyUyMCUyMmVwb2NoJTIy",highlighted:`accelerate launch \\
--mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
peft_lora_embedding_semantic_search.py \\
--dataset_name=<span class="hljs-string">&quot;smangrul/amazon_esci&quot;</span> \\
--max_length=70 --model_name_or_path=<span class="hljs-string">&quot;intfloat/e5-large-v2&quot;</span> \\
--per_device_train_batch_size=64 \\
--per_device_eval_batch_size=128 \\
--learning_rate=5e-4 \\
--weight_decay=0.0 \\
--num_train_epochs 3 \\
--gradient_accumulation_steps=1 \\
--output_dir=<span class="hljs-string">&quot;results/peft_lora_e5_ecommerce_semantic_search_colab&quot;</span> \\
--seed=42 \\
--push_to_hub \\
--hub_model_id=<span class="hljs-string">&quot;smangrul/peft_lora_e5_ecommerce_semantic_search_colab&quot;</span> \\
--with_tracking \\
--report_to=<span class="hljs-string">&quot;wandb&quot;</span> \\
--use_peft \\
--checkpointing_steps <span class="hljs-string">&quot;epoch&quot;</span>`,wrap:!1}}),F=new ue({props:{title:"Dataset for semantic similarity",local:"dataset-for-semantic-similarity",headingTag:"h2"}}),L=new ue({props:{title:"Training script deep dive",local:"training-script-deep-dive",headingTag:"h2"}}),P=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AutoModelForSentenceEmbedding</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name, tokenizer, normalize=<span class="hljs-literal">True</span></span>):
        <span class="hljs-built_in">super</span>(AutoModelForSentenceEmbedding, self).__init__()

        self.model = AutoModel.from_pretrained(model_name)  
        self.normalize = normalize
        self.tokenizer = tokenizer

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, **kwargs</span>):
        model_output = self.model(**kwargs)
        embeddings = self.mean_pooling(model_output, kwargs[<span class="hljs-string">&quot;attention_mask&quot;</span>])
        <span class="hljs-keyword">if</span> self.normalize:
            embeddings = torch.nn.functional.normalize(embeddings, p=<span class="hljs-number">2</span>, dim=<span class="hljs-number">1</span>)

        <span class="hljs-keyword">return</span> embeddings

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">mean_pooling</span>(<span class="hljs-params">self, model_output, attention_mask</span>):
        token_embeddings = model_output[<span class="hljs-number">0</span>]  <span class="hljs-comment"># First element of model_output contains all token embeddings</span>
        input_mask_expanded = attention_mask.unsqueeze(-<span class="hljs-number">1</span>).expand(token_embeddings.size()).<span class="hljs-built_in">float</span>()
        <span class="hljs-keyword">return</span> torch.<span class="hljs-built_in">sum</span>(token_embeddings * input_mask_expanded, <span class="hljs-number">1</span>) / torch.clamp(input_mask_expanded.<span class="hljs-built_in">sum</span>(<span class="hljs-number">1</span>), <span class="hljs-built_in">min</span>=<span class="hljs-number">1e-9</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getattr__</span>(<span class="hljs-params">self, name: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-string">&quot;&quot;&quot;Forward missing attributes to the wrapped module.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">try</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().__getattr__(name)  <span class="hljs-comment"># defer to nn.Module&#x27;s logic</span>
        <span class="hljs-keyword">except</span> AttributeError:
            <span class="hljs-keyword">return</span> <span class="hljs-built_in">getattr</span>(self.model, name)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_cosine_embeddings</span>(<span class="hljs-params">query_embs, product_embs</span>):
    <span class="hljs-keyword">return</span> torch.<span class="hljs-built_in">sum</span>(query_embs * product_embs, axis=<span class="hljs-number">1</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_loss</span>(<span class="hljs-params">cosine_score, labels</span>):
    <span class="hljs-keyword">return</span> torch.mean(torch.square(labels * (<span class="hljs-number">1</span> - cosine_score) + torch.clamp((<span class="hljs-number">1</span> - labels) * cosine_score, <span class="hljs-built_in">min</span>=<span class="hljs-number">0.0</span>)))`,wrap:!1}}),ee=new ue({props:{title:"Results",local:"results",headingTag:"h2"}}),ne=new ue({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Me=new u({props:{code:"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",highlighted:`{0: <span class="hljs-string">&#x27;RamPro 10&quot; All Purpose Utility Air Tires/Wheels with a 5/8&quot; Diameter Hole with Double Sealed Bearings (Pack of 2)&#x27;</span>,
 1: <span class="hljs-string">&#x27;MaxAuto 2-Pack 13x5.00-6 2PLY Turf Mower Tractor Tire with Yellow Rim, (3&quot; Centered Hub, 3/4&quot; Bushings )&#x27;</span>,
 2: <span class="hljs-string">&#x27;NEIKO 20601A 14.5 inch Steel Tire Spoon Lever Iron Tool Kit | Professional Tire Changing Tool for Motorcycle, Dirt Bike, Lawn Mower | 3 pcs Tire Spoons | 3 Rim Protector | Valve Tool | 6 Valve Cores&#x27;</span>,
 3: <span class="hljs-string">&#x27;2PK 13x5.00-6 13x5.00x6 13x5x6 13x5-6 2PLY Turf Mower Tractor Tire with Gray Rim&#x27;</span>,
 4: <span class="hljs-string">&#x27;(Set of 2) 15x6.00-6 Husqvarna/Poulan Tire Wheel Assy .75&quot; Bearing&#x27;</span>,
 5: <span class="hljs-string">&#x27;MaxAuto 2 Pcs 16x6.50-8 Lawn Mower Tire for Garden Tractors Ridings, 4PR, Tubeless&#x27;</span>,
 6: <span class="hljs-string">&#x27;Dr.Roc Tire Spoon Lever Dirt Bike Lawn Mower Motorcycle Tire Changing Tools with Durable Bag 3 Tire Irons 2 Rim Protectors 1 Valve Stems Set TR412 TR413&#x27;</span>,
 7: <span class="hljs-string">&#x27;MARASTAR 21446-2PK 15x6.00-6&quot; Front Tire Assembly Replacement-Craftsman Mower, Pack of 2&#x27;</span>,
 8: <span class="hljs-string">&#x27;15x6.00-6&quot; Front Tire Assembly Replacement for 100 and 300 Series John Deere Riding Mowers - 2 pack&#x27;</span>,
 9: <span class="hljs-string">&#x27;Honda HRR Wheel Kit (2 Front 44710-VL0-L02ZB, 2 Back 42710-VE2-M02ZE)&#x27;</span>,
 10: <span class="hljs-string">&#x27;Honda 42710-VE2-M02ZE (Replaces 42710-VE2-M01ZE) Lawn Mower Rear Wheel Set of 2&#x27;</span> ...`,wrap:!1}}),re=new u({props:{code:"JTIzJTIwYmFzZSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW50ZW5jZUVtYmVkZGluZyhtb2RlbF9uYW1lX29yX3BhdGglMkMlMjB0b2tlbml6ZXIpJTBBJTBBJTIzJTIwcGVmdCUyMGNvbmZpZyUyMGFuZCUyMHdyYXBwaW5nJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCklMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBbW9kZWwudG8oZGV2aWNlKSUwQW1vZGVsLmV2YWwoKSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBbnVtX3Byb2R1Y3RzJTNEJTIwbGVuKGRhdGFzZXQpJTBBZCUyMCUzRCUyMDEwMjQlMEElMEFwcm9kdWN0X2VtYmVkZGluZ3NfYXJyYXklMjAlM0QlMjBucC56ZXJvcygobnVtX3Byb2R1Y3RzJTJDJTIwZCkpJTBBZm9yJTIwc3RlcCUyQyUyMGJhdGNoJTIwaW4lMjBlbnVtZXJhdGUodHFkbShkYXRhbG9hZGVyKSklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLmFtcC5hdXRvY2FzdChkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX3R5cGUlM0QlMjJjdWRhJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2R1Y3RfZW1icyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQXYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEKS5kZXRhY2goKS5mbG9hdCgpLmNwdSgpJTBBJTIwJTIwJTIwJTIwc3RhcnRfaW5kZXglMjAlM0QlMjBzdGVwKmJhdGNoX3NpemUlMEElMjAlMjAlMjAlMjBlbmRfaW5kZXglMjAlM0QlMjBzdGFydF9pbmRleCUyQmJhdGNoX3NpemUlMjBpZiUyMCUyMChzdGFydF9pbmRleCUyQmJhdGNoX3NpemUpJTIwJTNDJTIwbnVtX3Byb2R1Y3RzJTIwZWxzZSUyMG51bV9wcm9kdWN0cyUwQSUyMCUyMCUyMCUyMHByb2R1Y3RfZW1iZWRkaW5nc19hcnJheSU1QnN0YXJ0X2luZGV4JTNBZW5kX2luZGV4JTVEJTIwJTNEJTIwcHJvZHVjdF9lbWJzJTBBJTIwJTIwJTIwJTIwZGVsJTIwcHJvZHVjdF9lbWJzJTJDJTIwYmF0Y2g=",highlighted:`<span class="hljs-comment"># base model</span>
model = AutoModelForSentenceEmbedding(model_name_or_path, tokenizer)

<span class="hljs-comment"># peft config and wrapping</span>
model = PeftModel.from_pretrained(model, peft_model_id)

device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)
model.<span class="hljs-built_in">eval</span>()
model = model.merge_and_unload()

<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
num_products= <span class="hljs-built_in">len</span>(dataset)
d = <span class="hljs-number">1024</span>

product_embeddings_array = np.zeros((num_products, d))
<span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(dataloader)):
    <span class="hljs-keyword">with</span> torch.no_grad():
        <span class="hljs-keyword">with</span> torch.amp.autocast(dtype=torch.bfloat16, device_type=<span class="hljs-string">&quot;cuda&quot;</span>):
            product_embs = model(**{k:v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}).detach().<span class="hljs-built_in">float</span>().cpu()
    start_index = step*batch_size
    end_index = start_index+batch_size <span class="hljs-keyword">if</span>  (start_index+batch_size) &lt; num_products <span class="hljs-keyword">else</span> num_products
    product_embeddings_array[start_index:end_index] = product_embs
    <span class="hljs-keyword">del</span> product_embs, batch`,wrap:!1}}),oe=new u({props:{code:"ZGVmJTIwY29uc3RydWN0X3NlYXJjaF9pbmRleChkaW0lMkMlMjBudW1fZWxlbWVudHMlMkMlMjBkYXRhKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERlY2xhcmluZyUyMGluZGV4JTBBJTIwJTIwJTIwJTIwc2VhcmNoX2luZGV4JTIwJTNEJTIwaG5zd2xpYi5JbmRleChzcGFjZSUyMCUzRCUyMCdpcCclMkMlMjBkaW0lMjAlM0QlMjBkaW0pJTIwJTIzJTIwcG9zc2libGUlMjBvcHRpb25zJTIwYXJlJTIwbDIlMkMlMjBjb3NpbmUlMjBvciUyMGlwJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW5pdGlhbGl6aW5nJTIwaW5kZXglMjAtJTIwdGhlJTIwbWF4aW11bSUyMG51bWJlciUyMG9mJTIwZWxlbWVudHMlMjBzaG91bGQlMjBiZSUyMGtub3duJTIwYmVmb3JlaGFuZCUwQSUyMCUyMCUyMCUyMHNlYXJjaF9pbmRleC5pbml0X2luZGV4KG1heF9lbGVtZW50cyUyMCUzRCUyMG51bV9lbGVtZW50cyUyQyUyMGVmX2NvbnN0cnVjdGlvbiUyMCUzRCUyMDIwMCUyQyUyME0lMjAlM0QlMjAxMDApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRWxlbWVudCUyMGluc2VydGlvbiUyMChjYW4lMjBiZSUyMGNhbGxlZCUyMHNldmVyYWwlMjB0aW1lcyklM0ElMEElMjAlMjAlMjAlMjBpZHMlMjAlM0QlMjBucC5hcmFuZ2UobnVtX2VsZW1lbnRzKSUwQSUyMCUyMCUyMCUyMHNlYXJjaF9pbmRleC5hZGRfaXRlbXMoZGF0YSUyQyUyMGlkcyklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWFyY2hfaW5kZXglMEElMEFwcm9kdWN0X3NlYXJjaF9pbmRleCUyMCUzRCUyMGNvbnN0cnVjdF9zZWFyY2hfaW5kZXgoZCUyQyUyMG51bV9wcm9kdWN0cyUyQyUyMHByb2R1Y3RfZW1iZWRkaW5nc19hcnJheSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">construct_search_index</span>(<span class="hljs-params">dim, num_elements, data</span>):
    <span class="hljs-comment"># Declaring index</span>
    search_index = hnswlib.Index(space = <span class="hljs-string">&#x27;ip&#x27;</span>, dim = dim) <span class="hljs-comment"># possible options are l2, cosine or ip</span>
    
    <span class="hljs-comment"># Initializing index - the maximum number of elements should be known beforehand</span>
    search_index.init_index(max_elements = num_elements, ef_construction = <span class="hljs-number">200</span>, M = <span class="hljs-number">100</span>)

    <span class="hljs-comment"># Element insertion (can be called several times):</span>
    ids = np.arange(num_elements)
    search_index.add_items(data, ids)

    <span class="hljs-keyword">return</span> search_index

product_search_index = construct_search_index(d, num_products, product_embeddings_array)`,wrap:!1}}),ce=new u({props:{code:"ZGVmJTIwZ2V0X3F1ZXJ5X2VtYmVkZGluZ3MocXVlcnklMkMlMjBtb2RlbCUyQyUyMHRva2VuaXplciUyQyUyMGRldmljZSklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlcnklMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMG1heF9sZW5ndGglM0Q3MCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBtb2RlbC5ldmFsKCklMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnlfZW1icyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQXYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCkuZGV0YWNoKCkuY3B1KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBxdWVyeV9lbWJzJTVCMCU1RCUwQSUwQSUyMCUyMCUyMCUyMCUwQWRlZiUyMGdldF9uZWFyZXN0X25laWdoYm91cnMoayUyQyUyMHNlYXJjaF9pbmRleCUyQyUyMHF1ZXJ5X2VtYmVkZGluZ3MlMkMlMjBpZHNfdG9fcHJvZHVjdHNfZGljdCUyQyUyMHRocmVzaG9sZCUzRDAuNyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBDb250cm9sbGluZyUyMHRoZSUyMHJlY2FsbCUyMGJ5JTIwc2V0dGluZyUyMGVmJTNBJTBBJTIwJTIwJTIwJTIwc2VhcmNoX2luZGV4LnNldF9lZigxMDApJTIwJTIzJTIwZWYlMjBzaG91bGQlMjBhbHdheXMlMjBiZSUyMCUzRSUyMGslMEElMEElMjAlMjAlMjAlMjAlMjMlMjBRdWVyeSUyMGRhdGFzZXQlMkMlMjBrJTIwLSUyMG51bWJlciUyMG9mJTIwdGhlJTIwY2xvc2VzdCUyMGVsZW1lbnRzJTIwKHJldHVybnMlMjAyJTIwbnVtcHklMjBhcnJheXMpJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTJDJTIwZGlzdGFuY2VzJTIwJTNEJTIwc2VhcmNoX2luZGV4Lmtubl9xdWVyeShxdWVyeV9lbWJlZGRpbmdzJTJDJTIwayUyMCUzRCUyMGspJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCKGlkc190b19wcm9kdWN0c19kaWN0JTVCbGFiZWwlNUQlMkMlMjAoMS1kaXN0YW5jZSkpJTIwZm9yJTIwbGFiZWwlMkMlMjBkaXN0YW5jZSUyMGluJTIwemlwKGxhYmVscyU1QjAlNUQlMkMlMjBkaXN0YW5jZXMlNUIwJTVEKSUyMGlmJTIwKDEtZGlzdGFuY2UpJTNFJTNEdGhyZXNob2xkJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_query_embeddings</span>(<span class="hljs-params">query, model, tokenizer, device</span>):
    inputs = tokenizer(query, padding=<span class="hljs-string">&quot;max_length&quot;</span>, max_length=<span class="hljs-number">70</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">with</span> torch.no_grad():
        query_embs = model(**{k:v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}).detach().cpu()
    <span class="hljs-keyword">return</span> query_embs[<span class="hljs-number">0</span>]

    
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_nearest_neighbours</span>(<span class="hljs-params">k, search_index, query_embeddings, ids_to_products_dict, threshold=<span class="hljs-number">0.7</span></span>):
    <span class="hljs-comment"># Controlling the recall by setting ef:</span>
    search_index.set_ef(<span class="hljs-number">100</span>) <span class="hljs-comment"># ef should always be &gt; k</span>

    <span class="hljs-comment"># Query dataset, k - number of the closest elements (returns 2 numpy arrays)</span>
    labels, distances = search_index.knn_query(query_embeddings, k = k)
    
    <span class="hljs-keyword">return</span> [(ids_to_products_dict[label], (<span class="hljs-number">1</span>-distance)) <span class="hljs-keyword">for</span> label, distance <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels[<span class="hljs-number">0</span>], distances[<span class="hljs-number">0</span>]) <span class="hljs-keyword">if</span> (<span class="hljs-number">1</span>-distance)&gt;=threshold]`,wrap:!1}}),pe=new u({props:{code:"cXVlcnklMjAlM0QlMjAlMjJkZWVwJTIwbGVhcm5pbmclMjBib29rcyUyMiUwQWslMjAlM0QlMjAxMCUwQXF1ZXJ5X2VtYmVkZGluZ3MlMjAlM0QlMjBnZXRfcXVlcnlfZW1iZWRkaW5ncyhxdWVyeSUyQyUyMG1vZGVsJTJDJTIwdG9rZW5pemVyJTJDJTIwZGV2aWNlKSUwQXNlYXJjaF9yZXN1bHRzJTIwJTNEJTIwZ2V0X25lYXJlc3RfbmVpZ2hib3VycyhrJTJDJTIwcHJvZHVjdF9zZWFyY2hfaW5kZXglMkMlMjBxdWVyeV9lbWJlZGRpbmdzJTJDJTIwaWRzX3RvX3Byb2R1Y3RzX2RpY3QlMkMlMjB0aHJlc2hvbGQlM0QwLjcpJTBBJTBBcHJpbnQoZiUyMiU3QnF1ZXJ5JTNEJTdEJTIyKSUyMCUwQWZvciUyMHByb2R1Y3QlMkMlMjBjb3NpbmVfc2ltX3Njb3JlJTIwaW4lMjBzZWFyY2hfcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJjb3NpbmVfc2ltX3Njb3JlJTNEJTdCcm91bmQoY29zaW5lX3NpbV9zY29yZSUyQzIpJTdEJTIwJTdCcHJvZHVjdCUzRCU3RCUyMik=",highlighted:`query = <span class="hljs-string">&quot;deep learning books&quot;</span>
k = <span class="hljs-number">10</span>
query_embeddings = get_query_embeddings(query, model, tokenizer, device)
search_results = get_nearest_neighbours(k, product_search_index, query_embeddings, ids_to_products_dict, threshold=<span class="hljs-number">0.7</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{query=}</span>&quot;</span>) 
<span class="hljs-keyword">for</span> product, cosine_sim_score <span class="hljs-keyword">in</span> search_results:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;cosine_sim_score=<span class="hljs-subst">{<span class="hljs-built_in">round</span>(cosine_sim_score,<span class="hljs-number">2</span>)}</span> <span class="hljs-subst">{product=}</span>&quot;</span>)`,wrap:!1}}),ye=new u({props:{code:"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",highlighted:`query=<span class="hljs-string">&#x27;deep learning books&#x27;</span>
cosine_sim_score=0.95 product=<span class="hljs-string">&#x27;Deep Learning (The MIT Press Essential Knowledge series)&#x27;</span>
cosine_sim_score=0.93 product=<span class="hljs-string">&#x27;Practical Deep Learning: A Python-Based Introduction&#x27;</span>
cosine_sim_score=0.9 product=<span class="hljs-string">&#x27;Hands-On Machine Learning with Scikit-Learn and TensorFlow: Concepts, Tools, and Techniques to Build Intelligent Systems&#x27;</span>
cosine_sim_score=0.9 product=<span class="hljs-string">&#x27;Machine Learning: A Hands-On, Project-Based Introduction to Machine Learning for Absolute Beginners: Mastering Engineering ML Systems using Scikit-Learn and TensorFlow&#x27;</span>
cosine_sim_score=0.9 product=<span class="hljs-string">&#x27;Mastering Machine Learning on AWS: Advanced machine learning in Python using SageMaker, Apache Spark, and TensorFlow&#x27;</span>
cosine_sim_score=0.9 product=<span class="hljs-string">&#x27;The Hundred-Page Machine Learning Book&#x27;</span>
cosine_sim_score=0.89 product=<span class="hljs-string">&#x27;Hands-On Machine Learning with Scikit-Learn, Keras, and TensorFlow: Concepts, Tools, and Techniques to Build Intelligent Systems&#x27;</span>
cosine_sim_score=0.89 product=<span class="hljs-string">&#x27;Machine Learning: A Journey from Beginner to Advanced Including Deep Learning, Scikit-learn and Tensorflow&#x27;</span>
cosine_sim_score=0.88 product=<span class="hljs-string">&#x27;Mastering Machine Learning with scikit-learn&#x27;</span>
cosine_sim_score=0.88 product=<span class="hljs-string">&#x27;Mastering Machine Learning with scikit-learn - Second Edition: Apply effective learning algorithms to real-world problems using scikit-learn&#x27;</span>`,wrap:!1}}),{c(){o=i("meta"),h=n(),T=i("p"),w=n(),c(C.$$.fragment),Ue=n(),W=i("p"),W.textContent=ul,be=n(),c(U.$$.fragment),je=n(),B=i("p"),B.innerHTML=hl,fe=n(),c(_.$$.fragment),Ie=n(),k=i("p"),k.innerHTML=wl,Ze=n(),c(V.$$.fragment),ge=n(),G=i("p"),G.textContent=Ul,Ce=n(),c(R.$$.fragment),We=n(),X=i("p"),X.textContent=bl,Be=n(),v=i("ul"),v.innerHTML=jl,_e=n(),c(b.$$.fragment),ke=n(),c(N.$$.fragment),Ve=n(),x=i("p"),x.innerHTML=fl,Ge=n(),A=i("p"),A.innerHTML=Il,Re=n(),c(E.$$.fragment),Xe=n(),Y=i("p"),Y.textContent=Zl,ve=n(),c(z.$$.fragment),Ne=n(),c(F.$$.fragment),xe=n(),S=i("p"),S.innerHTML=gl,Ae=n(),Q=i("p"),Q.innerHTML=Cl,Ee=n(),H=i("p"),H.innerHTML=Wl,Ye=n(),j=i("div"),j.innerHTML=Bl,ze=n(),$=i("p"),$.textContent=_l,Fe=n(),c(L.$$.fragment),Se=n(),D=i("p"),D.innerHTML=kl,Qe=n(),q=i("p"),q.innerHTML=Vl,He=n(),c(P.$$.fragment),$e=n(),K=i("p"),K.innerHTML=Gl,Le=n(),O=i("p"),O.innerHTML=Rl,De=n(),c(ee.$$.fragment),qe=n(),le=i("p"),le.textContent=Xl,Pe=n(),se=i("table"),se.innerHTML=vl,Ke=n(),te=i("p"),te.innerHTML=Nl,Oe=n(),c(ne.$$.fragment),el=n(),ae=i("p"),ae.innerHTML=xl,ll=n(),ie=i("ol"),ie.innerHTML=Al,sl=n(),c(Me.$$.fragment),tl=n(),f=i("ol"),f.innerHTML=El,nl=n(),c(re.$$.fragment),al=n(),I=i("ol"),I.innerHTML=Yl,il=n(),c(oe.$$.fragment),Ml=n(),Z=i("ol"),Z.innerHTML=zl,rl=n(),c(ce.$$.fragment),ol=n(),g=i("ol"),g.innerHTML=Fl,cl=n(),c(pe.$$.fragment),pl=n(),de=i("p"),de.textContent=Sl,dl=n(),c(ye.$$.fragment),yl=n(),me=i("p"),me.innerHTML=Ql,ml=n(),Je=i("p"),Je.innerHTML=Hl,Jl=n(),we=i("p"),this.h()},l(e){const l=ss("svelte-u9bgzb",document.head);o=M(l,"META",{name:!0,content:!0}),l.forEach(s),h=a(e),T=M(e,"P",{}),Dl(T).forEach(s),w=a(e),p(C.$$.fragment,e),Ue=a(e),W=M(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-353m1i"&&(W.textContent=ul),be=a(e),p(U.$$.fragment,e),je=a(e),B=M(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-6y4loe"&&(B.innerHTML=hl),fe=a(e),p(_.$$.fragment,e),Ie=a(e),k=M(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-vrp1vf"&&(k.innerHTML=wl),Ze=a(e),p(V.$$.fragment,e),ge=a(e),G=M(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1n3ddk8"&&(G.textContent=Ul),Ce=a(e),p(R.$$.fragment,e),We=a(e),X=M(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-18vnupi"&&(X.textContent=bl),Be=a(e),v=M(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-15qbnhq"&&(v.innerHTML=jl),_e=a(e),p(b.$$.fragment,e),ke=a(e),p(N.$$.fragment,e),Ve=a(e),x=M(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-aizb54"&&(x.innerHTML=fl),Ge=a(e),A=M(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-bgdq0k"&&(A.innerHTML=Il),Re=a(e),p(E.$$.fragment,e),Xe=a(e),Y=M(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-flxlze"&&(Y.textContent=Zl),ve=a(e),p(z.$$.fragment,e),Ne=a(e),p(F.$$.fragment,e),xe=a(e),S=M(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-wh50j5"&&(S.innerHTML=gl),Ae=a(e),Q=M(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-19ngtua"&&(Q.innerHTML=Cl),Ee=a(e),H=M(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1ib7v0n"&&(H.innerHTML=Wl),Ye=a(e),j=M(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-kogcmz"&&(j.innerHTML=Bl),ze=a(e),$=M(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1t2k6pu"&&($.textContent=_l),Fe=a(e),p(L.$$.fragment,e),Se=a(e),D=M(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ld3u6n"&&(D.innerHTML=kl),Qe=a(e),q=M(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1mo19ys"&&(q.innerHTML=Vl),He=a(e),p(P.$$.fragment,e),$e=a(e),K=M(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1cr32im"&&(K.innerHTML=Gl),Le=a(e),O=M(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-11m1zss"&&(O.innerHTML=Rl),De=a(e),p(ee.$$.fragment,e),qe=a(e),le=M(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1dw8my2"&&(le.textContent=Xl),Pe=a(e),se=M(e,"TABLE",{"data-svelte-h":!0}),r(se)!=="svelte-972w8a"&&(se.innerHTML=vl),Ke=a(e),te=M(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-11j51po"&&(te.innerHTML=Nl),Oe=a(e),p(ne.$$.fragment,e),el=a(e),ae=M(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1me99gv"&&(ae.innerHTML=xl),ll=a(e),ie=M(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-6tki6c"&&(ie.innerHTML=Al),sl=a(e),p(Me.$$.fragment,e),tl=a(e),f=M(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-nbg6ns"&&(f.innerHTML=El),nl=a(e),p(re.$$.fragment,e),al=a(e),I=M(e,"OL",{start:!0,"data-svelte-h":!0}),r(I)!=="svelte-1h9vzxd"&&(I.innerHTML=Yl),il=a(e),p(oe.$$.fragment,e),Ml=a(e),Z=M(e,"OL",{start:!0,"data-svelte-h":!0}),r(Z)!=="svelte-bx7oe5"&&(Z.innerHTML=zl),rl=a(e),p(ce.$$.fragment,e),ol=a(e),g=M(e,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-1mm85it"&&(g.innerHTML=Fl),cl=a(e),p(pe.$$.fragment,e),pl=a(e),de=M(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1wuxk0l"&&(de.textContent=Sl),dl=a(e),p(ye.$$.fragment,e),yl=a(e),me=M(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1m2u26f"&&(me.innerHTML=Ql),ml=a(e),Je=M(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1wvbjsj"&&(Je.innerHTML=Hl),Jl=a(e),we=M(e,"P",{}),Dl(we).forEach(s),this.h()},h(){Te(o,"name","hf:doc:metadata"),Te(o,"content",rs),Te(j,"class","flex justify-center"),Te(f,"start","2"),Te(I,"start","3"),Te(Z,"start","4"),Te(g,"start","5")},m(e,l){ts(document.head,o),t(e,h,l),t(e,T,l),t(e,w,l),d(C,e,l),t(e,Ue,l),t(e,W,l),t(e,be,l),d(U,e,l),t(e,je,l),t(e,B,l),t(e,fe,l),d(_,e,l),t(e,Ie,l),t(e,k,l),t(e,Ze,l),d(V,e,l),t(e,ge,l),t(e,G,l),t(e,Ce,l),d(R,e,l),t(e,We,l),t(e,X,l),t(e,Be,l),t(e,v,l),t(e,_e,l),d(b,e,l),t(e,ke,l),d(N,e,l),t(e,Ve,l),t(e,x,l),t(e,Ge,l),t(e,A,l),t(e,Re,l),d(E,e,l),t(e,Xe,l),t(e,Y,l),t(e,ve,l),d(z,e,l),t(e,Ne,l),d(F,e,l),t(e,xe,l),t(e,S,l),t(e,Ae,l),t(e,Q,l),t(e,Ee,l),t(e,H,l),t(e,Ye,l),t(e,j,l),t(e,ze,l),t(e,$,l),t(e,Fe,l),d(L,e,l),t(e,Se,l),t(e,D,l),t(e,Qe,l),t(e,q,l),t(e,He,l),d(P,e,l),t(e,$e,l),t(e,K,l),t(e,Le,l),t(e,O,l),t(e,De,l),d(ee,e,l),t(e,qe,l),t(e,le,l),t(e,Pe,l),t(e,se,l),t(e,Ke,l),t(e,te,l),t(e,Oe,l),d(ne,e,l),t(e,el,l),t(e,ae,l),t(e,ll,l),t(e,ie,l),t(e,sl,l),d(Me,e,l),t(e,tl,l),t(e,f,l),t(e,nl,l),d(re,e,l),t(e,al,l),t(e,I,l),t(e,il,l),d(oe,e,l),t(e,Ml,l),t(e,Z,l),t(e,rl,l),d(ce,e,l),t(e,ol,l),t(e,g,l),t(e,cl,l),d(pe,e,l),t(e,pl,l),t(e,de,l),t(e,dl,l),d(ye,e,l),t(e,yl,l),t(e,me,l),t(e,ml,l),t(e,Je,l),t(e,Jl,l),t(e,we,l),Tl=!0},p(e,[l]){const $l={};l&2&&($l.$$scope={dirty:l,ctx:e}),U.$set($l);const Ll={};l&2&&(Ll.$$scope={dirty:l,ctx:e}),b.$set(Ll)},i(e){Tl||(y(C.$$.fragment,e),y(U.$$.fragment,e),y(_.$$.fragment,e),y(V.$$.fragment,e),y(R.$$.fragment,e),y(b.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),y(oe.$$.fragment,e),y(ce.$$.fragment,e),y(pe.$$.fragment,e),y(ye.$$.fragment,e),Tl=!0)},o(e){m(C.$$.fragment,e),m(U.$$.fragment,e),m(_.$$.fragment,e),m(V.$$.fragment,e),m(R.$$.fragment,e),m(b.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(Me.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(pe.$$.fragment,e),m(ye.$$.fragment,e),Tl=!1},d(e){e&&(s(h),s(T),s(w),s(Ue),s(W),s(be),s(je),s(B),s(fe),s(Ie),s(k),s(Ze),s(ge),s(G),s(Ce),s(We),s(X),s(Be),s(v),s(_e),s(ke),s(Ve),s(x),s(Ge),s(A),s(Re),s(Xe),s(Y),s(ve),s(Ne),s(xe),s(S),s(Ae),s(Q),s(Ee),s(H),s(Ye),s(j),s(ze),s($),s(Fe),s(Se),s(D),s(Qe),s(q),s(He),s($e),s(K),s(Le),s(O),s(De),s(qe),s(le),s(Pe),s(se),s(Ke),s(te),s(Oe),s(el),s(ae),s(ll),s(ie),s(sl),s(tl),s(f),s(nl),s(al),s(I),s(il),s(Ml),s(Z),s(rl),s(ol),s(g),s(cl),s(pl),s(de),s(dl),s(yl),s(me),s(ml),s(Je),s(Jl),s(we)),s(o),J(C,e),J(U,e),J(_,e),J(V,e),J(R,e),J(b,e),J(N,e),J(E,e),J(z,e),J(F,e),J(L,e),J(P,e),J(ee,e),J(ne,e),J(Me,e),J(re,e),J(oe,e),J(ce,e),J(pe,e),J(ye,e)}}}const rs='{"title":"LoRA for semantic similarity tasks","local":"lora-for-semantic-similarity-tasks","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Dataset for semantic similarity","local":"dataset-for-semantic-similarity","sections":[],"depth":2},{"title":"Training script deep dive","local":"training-script-deep-dive","sections":[],"depth":2},{"title":"Results","local":"results","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function os(he){return Ol(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ns}),[]}class Js extends es{constructor(o){super(),ls(this,o,os,Ms,Kl,{})}}export{Js as component};
