import{s as Me,o as ye,n as de}from"../chunks/scheduler.182ea377.js";import{S as fe,i as be,g as o,s as a,r as y,A as he,h as p,f as t,c as n,j as ue,u as d,x as c,k as ee,y as we,a as s,v as f,d as b,t as h,w}from"../chunks/index.abf12888.js";import{T as Je}from"../chunks/Tip.230e2334.js";import{C as le}from"../chunks/CodeBlock.57fe6e13.js";import{D as ge}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as te}from"../chunks/Heading.16916d63.js";function Ue(R){let i,J='For more context about the design choices behind community pipelines, please have a look at <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">this issue</a>.';return{c(){i=o("p"),i.innerHTML=J},l(m){i=p(m,"P",{"data-svelte-h":!0}),c(i)!=="svelte-18wmiaf"&&(i.innerHTML=J)},m(m,x){s(m,i,x)},p:de,d(m){m&&t(i)}}}function Te(R){let i,J,m,x,g,X,U,$,r,Y,T,se='Community pipelines allow you to get creative and build your own unique pipelines to share with the community. You can find all community pipelines in the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">diffusers/examples/community</a> folder along with inference and training examples for how to use them. This guide showcases some of the community pipelines and hopefully it’ll inspire you to create your own (feel free to open a PR with your own pipeline and we will merge it!).',E,j,ae='To load a community pipeline, use the <code>custom_pipeline</code> argument in <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to specify one of the files in <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">diffusers/examples/community</a>:',N,Z,z,C,ne="If a community pipeline doesn’t work as expected, please open a GitHub issue and mention the author.",Q,W,ie='You can learn more about community pipelines in the how to <a href="custom_pipeline_overview">load community pipelines</a> and how to <a href="contribute_pipeline">contribute a community pipeline</a> guides.',F,I,S,G,oe='The multilingual Stable Diffusion pipeline uses a pretrained <a href="https://huggingface.co/papluca/xlm-roberta-base-language-detection" rel="nofollow">XLM-RoBERTa</a> to identify a language and the <a href="https://huggingface.co/facebook/mbart-large-50-many-to-one-mmt" rel="nofollow">mBART-large-50</a> model to handle the translation. This allows you to generate images from text in 20 languages.',q,_,A,u,pe='<img src="https://user-images.githubusercontent.com/4313860/198328706-295824a4-9856-4ce5-8e66-278ceb42fd29.png"/>',H,k,L,B,me='<a href="https://huggingface.co/papers/2210.16056" rel="nofollow">MagicMix</a> is a pipeline that can mix an image and text prompt to generate a new image that preserves the image structure. The <code>mix_factor</code> determines how much influence the prompt has on the layout generation, <code>kmin</code> controls the number of steps during the content generation process, and <code>kmax</code> determines how much information is kept in the layout of the original image.',D,v,P,M,ce='<div><img class="rounded-xl" src="https://user-images.githubusercontent.com/59410571/209578593-141467c7-d831-4792-8b9a-b17dc5e47816.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://user-images.githubusercontent.com/59410571/209578602-70f323fa-05b7-4dd6-b055-e40683e37914.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image and text prompt mix</figcaption></div>',K,V,O;return g=new te({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h1"}}),U=new ge({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_examples.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_examples.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_examples.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_examples.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_examples.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_examples.ipynb"}]}}),r=new Je({props:{$$slots:{default:[Ue]},$$scope:{ctx:R}}}),Z=new le({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyZmlsZW5hbWVfaW5fdGhlX2NvbW11bml0eV9mb2xkZXIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;filename_in_the_community_folder&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),I=new te({props:{title:"Multilingual Stable Diffusion",local:"multilingual-stable-diffusion",headingTag:"h2"}}),_=new le({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
    pipeline,
    MBart50TokenizerFast,
    MBartForConditionalGeneration,
)

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
device_dict = {<span class="hljs-string">&quot;cuda&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;cpu&quot;</span>: -<span class="hljs-number">1</span>}

<span class="hljs-comment"># add language detection pipeline</span>
language_detection_model_ckpt = <span class="hljs-string">&quot;papluca/xlm-roberta-base-language-detection&quot;</span>
language_detection_pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>,
                                       model=language_detection_model_ckpt,
                                       device=device_dict[device])

<span class="hljs-comment"># add model for language translation</span>
translation_tokenizer = MBart50TokenizerFast.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-one-mmt&quot;</span>)
translation_model = MBartForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-one-mmt&quot;</span>).to(device)

diffuser_pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;multilingual_stable_diffusion&quot;</span>,
    detection_pipeline=language_detection_pipeline,
    translation_model=translation_model,
    translation_tokenizer=translation_tokenizer,
    torch_dtype=torch.float16,
)

diffuser_pipeline.enable_attention_slicing()
diffuser_pipeline = diffuser_pipeline.to(device)

prompt = [<span class="hljs-string">&quot;a photograph of an astronaut riding a horse&quot;</span>,
          <span class="hljs-string">&quot;Una casa en la playa&quot;</span>,
          <span class="hljs-string">&quot;Ein Hund, der Orange isst&quot;</span>,
          <span class="hljs-string">&quot;Un restaurant parisien&quot;</span>]

images = diffuser_pipeline(prompt).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),k=new te({props:{title:"MagicMix",local:"magicmix",headingTag:"h2"}}),v=new le({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMm1hZ2ljX21peCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTJDJTBBKS50bygnY3VkYScpJTBBJTBBaW1nJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRnVzZXItaW1hZ2VzLmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRjU5NDEwNTcxJTJGMjA5NTc4NTkzLTE0MTQ2N2M3LWQ4MzEtNDc5Mi04YjlhLWIxN2RjNWU0NzgxNi5qcGclMjIpJTBBbWl4X2ltZyUyMCUzRCUyMHBpcGVsaW5lKGltZyUyQyUyMHByb21wdCUzRCUyMmJlZCUyMiUyQyUyMGttaW4lM0QwLjMlMkMlMjBrbWF4JTNEMC41JTJDJTIwbWl4X2ZhY3RvciUzRDAuNSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCaW1nJTJDJTIwbWl4X2ltZyU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;magic_mix&quot;</span>,
    scheduler=DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>),
).to(<span class="hljs-string">&#x27;cuda&#x27;</span>)

img = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/59410571/209578593-141467c7-d831-4792-8b9a-b17dc5e47816.jpg&quot;</span>)
mix_img = pipeline(img, prompt=<span class="hljs-string">&quot;bed&quot;</span>, kmin=<span class="hljs-number">0.3</span>, kmax=<span class="hljs-number">0.5</span>, mix_factor=<span class="hljs-number">0.5</span>)
make_image_grid([img, mix_img], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),{c(){i=o("meta"),J=a(),m=o("p"),x=a(),y(g.$$.fragment),X=a(),y(U.$$.fragment),$=a(),y(r.$$.fragment),Y=a(),T=o("p"),T.innerHTML=se,E=a(),j=o("p"),j.innerHTML=ae,N=a(),y(Z.$$.fragment),z=a(),C=o("p"),C.textContent=ne,Q=a(),W=o("p"),W.innerHTML=ie,F=a(),y(I.$$.fragment),S=a(),G=o("p"),G.innerHTML=oe,q=a(),y(_.$$.fragment),A=a(),u=o("div"),u.innerHTML=pe,H=a(),y(k.$$.fragment),L=a(),B=o("p"),B.innerHTML=me,D=a(),y(v.$$.fragment),P=a(),M=o("div"),M.innerHTML=ce,K=a(),V=o("p"),this.h()},l(e){const l=he("svelte-u9bgzb",document.head);i=p(l,"META",{name:!0,content:!0}),l.forEach(t),J=n(e),m=p(e,"P",{}),ue(m).forEach(t),x=n(e),d(g.$$.fragment,e),X=n(e),d(U.$$.fragment,e),$=n(e),d(r.$$.fragment,e),Y=n(e),T=p(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-1baok02"&&(T.innerHTML=se),E=n(e),j=p(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1yuyo3a"&&(j.innerHTML=ae),N=n(e),d(Z.$$.fragment,e),z=n(e),C=p(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-19dq7yu"&&(C.textContent=ne),Q=n(e),W=p(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-ghaeyc"&&(W.innerHTML=ie),F=n(e),d(I.$$.fragment,e),S=n(e),G=p(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1ee0giq"&&(G.innerHTML=oe),q=n(e),d(_.$$.fragment,e),A=n(e),u=p(e,"DIV",{class:!0,"data-svelte-h":!0}),c(u)!=="svelte-1v1rdhr"&&(u.innerHTML=pe),H=n(e),d(k.$$.fragment,e),L=n(e),B=p(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-tjmn7p"&&(B.innerHTML=me),D=n(e),d(v.$$.fragment,e),P=n(e),M=p(e,"DIV",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-14yz3qw"&&(M.innerHTML=ce),K=n(e),V=p(e,"P",{}),ue(V).forEach(t),this.h()},h(){ee(i,"name","hf:doc:metadata"),ee(i,"content",je),ee(u,"class","flex justify-center"),ee(M,"class","flex gap-4")},m(e,l){we(document.head,i),s(e,J,l),s(e,m,l),s(e,x,l),f(g,e,l),s(e,X,l),f(U,e,l),s(e,$,l),f(r,e,l),s(e,Y,l),s(e,T,l),s(e,E,l),s(e,j,l),s(e,N,l),f(Z,e,l),s(e,z,l),s(e,C,l),s(e,Q,l),s(e,W,l),s(e,F,l),f(I,e,l),s(e,S,l),s(e,G,l),s(e,q,l),f(_,e,l),s(e,A,l),s(e,u,l),s(e,H,l),f(k,e,l),s(e,L,l),s(e,B,l),s(e,D,l),f(v,e,l),s(e,P,l),s(e,M,l),s(e,K,l),s(e,V,l),O=!0},p(e,[l]){const re={};l&2&&(re.$$scope={dirty:l,ctx:e}),r.$set(re)},i(e){O||(b(g.$$.fragment,e),b(U.$$.fragment,e),b(r.$$.fragment,e),b(Z.$$.fragment,e),b(I.$$.fragment,e),b(_.$$.fragment,e),b(k.$$.fragment,e),b(v.$$.fragment,e),O=!0)},o(e){h(g.$$.fragment,e),h(U.$$.fragment,e),h(r.$$.fragment,e),h(Z.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(k.$$.fragment,e),h(v.$$.fragment,e),O=!1},d(e){e&&(t(J),t(m),t(x),t(X),t($),t(Y),t(T),t(E),t(j),t(N),t(z),t(C),t(Q),t(W),t(F),t(S),t(G),t(q),t(A),t(u),t(H),t(L),t(B),t(D),t(P),t(M),t(K),t(V)),t(i),w(g,e),w(U,e),w(r,e),w(Z,e),w(I,e),w(_,e),w(k,e),w(v,e)}}}const je='{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Multilingual Stable Diffusion","local":"multilingual-stable-diffusion","sections":[],"depth":2},{"title":"MagicMix","local":"magicmix","sections":[],"depth":2}],"depth":1}';function Ze(R){return ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends fe{constructor(i){super(),be(this,i,Ze,Te,Me,{})}}export{Be as component};
