import{s as fs,o as hs,n as gl}from"../chunks/scheduler.182ea377.js";import{S as gs,i as Js,g as i,s as n,r,A as bs,h as o,f as l,c as a,j as ys,u as c,x as p,k as U,y as Us,a as s,v as d,d as M,t as u,w as y}from"../chunks/index.1ea56653.js";import{H as ze,g as ws}from"../chunks/Heading.71ac6e9f.js";import{T as hl}from"../chunks/Tip.67abc998.js";import{C as h}from"../chunks/CodeBlock.82c2494b.js";function Ts(T){let m,J='Check out Section 3.5 of the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">ControlNet</a> paper for a list of ControlNet implementations on various conditioning inputs. You can find the official Stable Diffusion ControlNet conditioned models on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel</a>’s Hub profile, and more <a href="https://huggingface.co/models?other=stable-diffusion&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.',f,g,Z='For Stable Diffusion XL (SDXL) ControlNet models, you can find them on the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization, or you can browse <a href="https://huggingface.co/models?other=stable-diffusion-xl&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.';return{c(){m=i("p"),m.innerHTML=J,f=n(),g=i("p"),g.innerHTML=Z},l(b){m=o(b,"P",{"data-svelte-h":!0}),p(m)!=="svelte-x0ucfg"&&(m.innerHTML=J),f=a(b),g=o(b,"P",{"data-svelte-h":!0}),p(g)!=="svelte-2pe81s"&&(g.innerHTML=Z)},m(b,w){s(b,m,w),s(b,f,w),s(b,g,w)},p:gl,d(b){b&&(l(m),l(f),l(g))}}}function Zs(T){let m,J="Guess mode does not have any impact on prompt conditioning and you can still provide a prompt if you want.";return{c(){m=i("p"),m.textContent=J},l(f){m=o(f,"P",{"data-svelte-h":!0}),p(m)!=="svelte-14ez4w"&&(m.textContent=J)},m(f,g){s(f,m,g)},p:gl,d(f){f&&l(m)}}}function js(T){let m,J='The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter determines how much weight to assign to the conditioning inputs. A value of 0.5 is recommended for good generalization, but feel free to experiment with this number!';return{c(){m=i("p"),m.innerHTML=J},l(f){m=o(f,"P",{"data-svelte-h":!0}),p(m)!=="svelte-52h992"&&(m.innerHTML=J)},m(f,g){s(f,m,g)},p:gl,d(f){f&&l(m)}}}function Ws(T){let m,J='Replace the SDXL model with a model like <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> to use multiple conditioning inputs with Stable Diffusion models.';return{c(){m=i("p"),m.innerHTML=J},l(f){m=o(f,"P",{"data-svelte-h":!0}),p(m)!=="svelte-lnumtz"&&(m.innerHTML=J)},m(f,g){s(f,m,g)},p:gl,d(f){f&&l(m)}}}function Cs(T){let m,J,f,g,Z,b,w,Jl="ControlNet is a type of model for controlling image diffusion models by conditioning the model with an additional input image. There are many types of conditioning inputs (canny edge, user sketching, human pose, depth, and more) you can use to control a diffusion model. This is hugely useful because it affords you greater control over image generation, making it easier to generate specific images without experimenting with different text prompts or denoising values as much.",De,j,Ae,S,bl="A ControlNet model has two sets of weights (or blocks) connected by a zero-convolution layer:",qe,F,Ul="<li>a <em>locked copy</em> keeps everything a large pretrained diffusion model has learned</li> <li>a <em>trainable copy</em> is trained on the additional conditioning input</li>",Pe,$,wl="Since the locked copy preserves the pretrained model, training and implementing a ControlNet on a new conditioning input is as fast as finetuning any other model because you aren’t training the model from scratch.",Ke,Q,Tl="This guide will show you how to use ControlNet for text-to-image, image-to-image, inpainting, and more! There are many types of ControlNet conditioning inputs to choose from, but in this guide we’ll only focus on several of them. Feel free to experiment with other conditioning inputs!",Oe,E,Zl="Before you begin, make sure you have the following libraries installed:",et,H,tt,z,lt,L,jl="For text-to-image, you normally pass a text prompt to the model. But with ControlNet, you can specify an additional conditioning input. Let’s condition the model with a canny image, a white outline of an image on a black background. This way, the ControlNet can use the canny image as a control to guide the model to generate an image with the same outline.",st,D,Wl='Load an image and use the <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a> library to extract the canny image:',nt,A,at,W,Cl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vermeer_canny_edged.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',it,q,vl='Next, load a ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',ot,P,pt,K,Bl="Now pass your prompt and canny image to the pipeline:",mt,O,rt,C,Gl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-text2img.png"/>',ct,ee,dt,te,Nl="For image-to-image, you’d typically pass an initial image and a prompt to the pipeline to generate a new image. With ControlNet, you can pass an additional conditioning input to guide the model. Let’s condition the model with a depth map, an image which contains spatial information. This way, the ControlNet can use the depth map as a control to guide the model to generate an image that preserves spatial information.",Mt,le,Il='You’ll use the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a> for this task, which is different from the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> because it allows you to pass an initial image as the starting point for the image generation process.',ut,se,kl='Load an image and use the <code>depth-estimation</code> <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline" rel="nofollow">Pipeline</a> from 🤗 Transformers to extract the depth map of an image:',yt,ne,ft,ae,Xl='Next, load a ControlNet model conditioned on depth maps and pass it to the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a>. Use the faster <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',ht,ie,gt,oe,Rl="Now pass your prompt, initial image, and depth map to the pipeline:",Jt,pe,bt,v,_l='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Ut,me,wt,re,xl="For inpainting, you need an initial image, a mask image, and a prompt describing what to replace the mask with. ControlNet models allow you to add another control image to condition a model with. Let’s condition the model with a canny image, a white outline of an image on a black background. This way, the ControlNet can use the canny image as a control to guide the model to generate an image with the same outline.",Tt,ce,Vl="Load an initial image and a mask image:",Zt,de,jt,Me,Yl="Create a function to prepare the control image from the initial and mask images. This’ll create a tensor to mark the pixels in <code>init_image</code> as masked if the corresponding pixel in <code>mask_image</code> is over a certain threshold.",Wt,ue,Ct,B,Sl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask image</figcaption></div>',vt,ye,Fl='Load a ControlNet model conditioned on inpainting and pass it to the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetInpaintPipeline">StableDiffusionControlNetInpaintPipeline</a>. Use the faster <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',Bt,fe,Gt,he,$l="Now pass your prompt, initial image, mask image, and control image to the pipeline:",Nt,ge,It,G,Ql='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-result.png"/>',kt,Je,Xt,be,El='<a href="https://github.com/lllyasviel/ControlNet/discussions/188" rel="nofollow">Guess mode</a> does not require supplying a prompt to a ControlNet at all! This forces the ControlNet encoder to do it’s best to “guess” the contents of the input control map (depth map, pose estimation, canny edge, etc.).',Rt,Ue,Hl="Guess mode adjusts the scale of the output residuals from a ControlNet by a fixed ratio depending on the block depth. The shallowest <code>DownBlock</code> corresponds to 0.1, and as the blocks get deeper, the scale increases exponentially such that the scale of the <code>MidBlock</code> output becomes 1.0.",_t,N,xt,we,zl='Set <code>guess_mode=True</code> in the pipeline, and it is <a href="https://github.com/lllyasviel/ControlNet#guess-mode--non-prompt-mode" rel="nofollow">recommended</a> to set the <code>guidance_scale</code> value between 3.0 and 5.0.',Vt,Te,Yt,I,Ll='<div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">regular mode with prompt</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0_gm.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guess mode without prompt</figcaption></div>',St,Ze,Ft,je,Dl='There aren’t too many ControlNet models compatible with Stable Diffusion XL (SDXL) at the moment, but we’ve trained two full-sized ControlNet models for SDXL conditioned on canny edge detection and depth maps. We’re also experimenting with creating smaller versions of these SDXL-compatible ControlNet models so it is easier to run on resource-constrained hardware. You can find these checkpoints on the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization!',$t,We,Al="Let’s use a SDXL ControlNet conditioned on canny images to generate an image. Start by loading an image and prepare the canny image:",Qt,Ce,Et,k,ql='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hf-logo-canny.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',Ht,ve,Pl='Load a SDXL ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. You can also enable model offloading to reduce memory usage.',zt,Be,Lt,Ge,Kl="Now pass your prompt (and optionally a negative prompt if you’re using one) and canny image to the pipeline:",Dt,X,At,Ne,qt,R,Ol='<img class="rounded-xl" src="https://huggingface.co/diffusers/controlnet-canny-sdxl-1.0/resolve/main/out_hug_lab_7.png"/>',Pt,Ie,es='You can use <a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a> in guess mode as well by setting the parameter to <code>True</code>:',Kt,ke,Ot,Xe,el,_,tl,Re,ts="You can compose multiple ControlNet conditionings from different image inputs to create a <em>MultiControlNet</em>. To get better results, it is often helpful to:",ll,_e,ls='<li>mask conditionings such that they don’t overlap (for example, mask the area of a canny image where the pose conditioning is located)</li> <li>experiment with the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter to determine how much weight to assign to each conditioning input</li>',sl,xe,ss="In this example, you’ll combine a canny image and a human pose estimation image to generate a new image.",nl,Ve,ns="Prepare the canny image conditioning:",al,Ye,il,x,as='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/landscape_canny_masked.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',ol,Se,is="Prepare the human pose estimation conditioning:",pl,Fe,ml,V,os='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/person_pose.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">human pose image</figcaption></div>',rl,$e,ps='Load a list of ControlNet models that correspond to each conditioning, and pass them to the <a href="/docs/diffusers/main/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to reduce memory usage.',cl,Qe,dl,Ee,ms="Now you can pass your prompt (an optional negative prompt if you’re using one), canny image, and pose image to the pipeline:",Ml,He,ul,Y,rs='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/multicontrolnet.png"/>',yl,Le,fl;return Z=new ze({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),j=new hl({props:{$$slots:{default:[Ts]},$$scope:{ctx:T}}}),H=new h({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMHNhZmV0ZW5zb3JzJTIwb3BlbmN2LXB5dGhvbg==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers transformers accelerate safetensors opencv-python</span>`,wrap:!1}}),z=new ze({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),A=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaGYuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucHV0X2ltYWdlX3Zlcm1lZXIucG5nJTIyJTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTBBbG93X3RocmVzaG9sZCUyMCUzRCUyMDEwMCUwQWhpZ2hfdGhyZXNob2xkJTIwJTNEJTIwMjAwJTBBJTBBaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjBsb3dfdGhyZXNob2xkJTJDJTIwaGlnaF90aHJlc2hvbGQpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`,wrap:!1}}),P=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),O=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBtb25hJTIwbGlzYSUyMiUyQyUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`output = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new ze({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),ne=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWltZzJpbWcuanBnJTIyJTBBKS5yZXNpemUoKDc2OCUyQyUyMDc2OCkpJTBBJTBBJTBBZGVmJTIwZ2V0X2RlcHRoX21hcChpbWFnZSUyQyUyMGRlcHRoX2VzdGltYXRvciklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMGRlcHRoX2VzdGltYXRvcihpbWFnZSklNUIlMjJkZXB0aCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQSUyMCUyMCUyMCUyMGRldGVjdGVkX21hcCUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoaW1hZ2UpLmZsb2F0KCklMjAlMkYlMjAyNTUuMCUwQSUyMCUyMCUyMCUyMGRlcHRoX21hcCUyMCUzRCUyMGRldGVjdGVkX21hcC5wZXJtdXRlKDIlMkMlMjAwJTJDJTIwMSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkZXB0aF9tYXAlMEElMEFkZXB0aF9lc3RpbWF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJkZXB0aC1lc3RpbWF0aW9uJTIyKSUwQWRlcHRoX21hcCUyMCUzRCUyMGdldF9kZXB0aF9tYXAoaW1hZ2UlMkMlMjBkZXB0aF9lc3RpbWF0b3IpLnVuc3F1ZWV6ZSgwKS5oYWxmKCkudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg&quot;</span>
).resize((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image, depth_estimator</span>):
    image = depth_estimator(image)[<span class="hljs-string">&quot;depth&quot;</span>]
    image = np.array(image)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    detected_map = torch.from_numpy(image).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>
    depth_map = detected_map.permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> depth_map

depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>)
depth_map = get_depth_map(image, depth_estimator).unsqueeze(<span class="hljs-number">0</span>).half().to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ie=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbWcySW1nUGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExZjFwX3NkMTVfZGVwdGglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),pe=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJsZWdvJTIwYmF0bWFuJTIwYW5kJTIwcm9iaW4lMjIlMkMlMjBpbWFnZSUzRGltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX21hcCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`output = pipe(
    <span class="hljs-string">&quot;lego batman and robin&quot;</span>, image=image, control_image=depth_map,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),me=new ze({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),de=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQuanBnJTIyJTBBKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQtbWFzay5qcGclMjIlMEEpJTBBbWFza19pbWFnZSUyMCUzRCUyMG1hc2tfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg&quot;</span>
)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg&quot;</span>
)
mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))`,wrap:!1}}),ue=new h({props:{code:"ZGVmJTIwbWFrZV9pbnBhaW50X2NvbmRpdGlvbihpbWFnZSUyQyUyMGltYWdlX21hc2spJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMikpLmFzdHlwZShucC5mbG9hdDMyKSUyMCUyRiUyMDI1NS4wJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbWFzayUyMCUzRCUyMG5wLmFycmF5KGltYWdlX21hc2suY29udmVydCglMjJMJTIyKSkuYXN0eXBlKG5wLmZsb2F0MzIpJTIwJTJGJTIwMjU1LjAlMEElMEElMjAlMjAlMjAlMjBhc3NlcnQlMjBpbWFnZS5zaGFwZSU1QjAlM0ExJTVEJTIwJTNEJTNEJTIwaW1hZ2VfbWFzay5zaGFwZSU1QjAlM0ExJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2UlNUJpbWFnZV9tYXNrJTIwJTNFJTIwMC41JTVEJTIwJTNEJTIwMS4wJTIwJTIwJTIzJTIwc2V0JTIwYXMlMjBtYXNrZWQlMjBwaXhlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuZXhwYW5kX2RpbXMoaW1hZ2UlMkMlMjAwKS50cmFuc3Bvc2UoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbWFrZV9pbnBhaW50X2NvbmRpdGlvbihpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">image, image_mask</span>):
    image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    image_mask = np.array(image_mask.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == image_mask.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>]
    image[image_mask &gt; <span class="hljs-number">0.5</span>] = <span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    image = np.expand_dims(image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    image = torch.from_numpy(image)
    <span class="hljs-keyword">return</span> image

control_image = make_inpaint_condition(init_image, mask_image)`,wrap:!1}}),fe=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExcF9zZDE1X2lucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0SW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),ge=new h({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJjb3JnaSUyMGZhY2UlMjB3aXRoJTIwbGFyZ2UlMjBlYXJzJTJDJTIwZGV0YWlsZWQlMkMlMjBwaXhhciUyQyUyMGFuaW1hdGVkJTJDJTIwZGlzbmV5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZXRhJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`output = pipe(
    <span class="hljs-string">&quot;corgi face with large ears, detailed, pixar, animated, disney&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    eta=<span class="hljs-number">1.0</span>,
    image=init_image,
    mask_image=mask_image,
    control_image=control_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Je=new ze({props:{title:"Guess mode",local:"guess-mode",headingTag:"h2"}}),N=new hl({props:{$$slots:{default:[Zs]},$$scope:{ctx:T}}}),Te=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRnNkLWNvbnRyb2xuZXQtY2FubnklMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMEElMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMjIlMjIlMkMlMjBpbWFnZSUzRGNhbm55X2ltYWdlJTJDJTIwZ3Vlc3NfbW9kZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, use_safetensors=<span class="hljs-literal">True</span>).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
image = pipe(<span class="hljs-string">&quot;&quot;</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3.0</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ze=new ze({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),Ce=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZzZF9jb250cm9sbmV0JTJGaGYtbG9nby5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2UpJTBBY2FubnlfaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
canny_image`,wrap:!1}}),Be=new h({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRHZhZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    vae=vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()`,wrap:!1}}),X=new hl({props:{$$slots:{default:[js]},$$scope:{ctx:T}}}),Ne=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYWVyaWFsJTIwdmlldyUyQyUyMGElMjBmdXR1cmlzdGljJTIwcmVzZWFyY2glMjBjb21wbGV4JTIwaW4lMjBhJTIwYnJpZ2h0JTIwZm9nZ3klMjBqdW5nbGUlMkMlMjBoYXJkJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAnbG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyclMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlcw==",highlighted:`prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&#x27;low quality, bad quality, sketches&#x27;</span>

images = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
).images[<span class="hljs-number">0</span>]
images`,wrap:!1}}),ke=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()

image = np.array(image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(
    prompt, controlnet_conditioning_scale=<span class="hljs-number">0.5</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Xe=new ze({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h3"}}),_=new hl({props:{$$slots:{default:[Ws]},$$scope:{ctx:T}}}),Ye=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBjdjIlMEElMEFjYW5ueV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbGFuZHNjYXBlLnBuZyUyMiUwQSklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMG5wLmFycmF5KGNhbm55X2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGNhbm55X2ltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQSUwQSUyMyUyMHplcm8lMjBvdXQlMjBtaWRkbGUlMjBjb2x1bW5zJTIwb2YlMjBpbWFnZSUyMHdoZXJlJTIwcG9zZSUyMHdpbGwlMjBiZSUyMG92ZXJsYWlkJTBBemVyb19zdGFydCUyMCUzRCUyMGNhbm55X2ltYWdlLnNoYXBlJTVCMSU1RCUyMCUyRiUyRiUyMDQlMEF6ZXJvX2VuZCUyMCUzRCUyMHplcm9fc3RhcnQlMjAlMkIlMjBjYW5ueV9pbWFnZS5zaGFwZSU1QjElNUQlMjAlMkYlMkYlMjAyJTBBY2FubnlfaW1hZ2UlNUIlM0ElMkMlMjB6ZXJvX3N0YXJ0JTNBemVyb19lbmQlNUQlMjAlM0QlMjAwJTBBJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBjYW5ueV9pbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFjYW5ueV9pbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmNhbm55X2ltYWdlJTJDJTIwY2FubnlfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGNhbm55X2ltYWdlKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> cv2

canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
)
canny_image = np.array(canny_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

canny_image = cv2.Canny(canny_image, low_threshold, high_threshold)

<span class="hljs-comment"># zero out middle columns of image where pose will be overlaid</span>
zero_start = canny_image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">4</span>
zero_end = zero_start + canny_image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
canny_image[:, zero_start:zero_end] = <span class="hljs-number">0</span>

canny_image = canny_image[:, :, <span class="hljs-literal">None</span>]
canny_image = np.concatenate([canny_image, canny_image, canny_image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(canny_image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))`,wrap:!1}}),Fe=new h({props:{code:"ZnJvbSUyMGNvbnRyb2xuZXRfYXV4JTIwaW1wb3J0JTIwT3BlbnBvc2VEZXRlY3RvciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBb3BlbnBvc2UlMjAlM0QlMjBPcGVucG9zZURldGVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGQ29udHJvbE5ldCUyMiklMEElMEFvcGVucG9zZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGcGVyc29uLnBuZyUyMiUwQSklMEFvcGVucG9zZV9pbWFnZSUyMCUzRCUyMG9wZW5wb3NlKG9wZW5wb3NlX2ltYWdlKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSk=",highlighted:`<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

openpose = OpenposeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/ControlNet&quot;</span>)

openpose_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png&quot;</span>
)
openpose_image = openpose(openpose_image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))`,wrap:!1}}),Qe=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGhpYmF1ZCUyRmNvbnRyb2xuZXQtb3BlbnBvc2Utc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTJDJTBBJTVEJTBBJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldHMlMkMlMjB2YWUlM0R2YWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;thibaud/controlnet-openpose-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
    ),
]

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnets, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`,wrap:!1}}),He=new h({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdpYW50JTIwc3RhbmRpbmclMjBpbiUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwYmVzdCUyMHF1YWxpdHklMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgxKSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1Qm9wZW5wb3NlX2ltYWdlJTJDJTIwY2FubnlfaW1hZ2UlNUQlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEJTVCMS4wJTJDJTIwMC44JTVEJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`prompt = <span class="hljs-string">&quot;a giant standing in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">1</span>)

images = [openpose_image, canny_image]

images = pipe(
    prompt,
    image=images,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    negative_prompt=negative_prompt,
    num_images_per_prompt=<span class="hljs-number">3</span>,
    controlnet_conditioning_scale=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>],
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){m=i("meta"),J=n(),f=i("p"),g=n(),r(Z.$$.fragment),b=n(),w=i("p"),w.textContent=Jl,De=n(),r(j.$$.fragment),Ae=n(),S=i("p"),S.textContent=bl,qe=n(),F=i("ul"),F.innerHTML=Ul,Pe=n(),$=i("p"),$.textContent=wl,Ke=n(),Q=i("p"),Q.textContent=Tl,Oe=n(),E=i("p"),E.textContent=Zl,et=n(),r(H.$$.fragment),tt=n(),r(z.$$.fragment),lt=n(),L=i("p"),L.textContent=jl,st=n(),D=i("p"),D.innerHTML=Wl,nt=n(),r(A.$$.fragment),at=n(),W=i("div"),W.innerHTML=Cl,it=n(),q=i("p"),q.innerHTML=vl,ot=n(),r(P.$$.fragment),pt=n(),K=i("p"),K.textContent=Bl,mt=n(),r(O.$$.fragment),rt=n(),C=i("div"),C.innerHTML=Gl,ct=n(),r(ee.$$.fragment),dt=n(),te=i("p"),te.textContent=Nl,Mt=n(),le=i("p"),le.innerHTML=Il,ut=n(),se=i("p"),se.innerHTML=kl,yt=n(),r(ne.$$.fragment),ft=n(),ae=i("p"),ae.innerHTML=Xl,ht=n(),r(ie.$$.fragment),gt=n(),oe=i("p"),oe.textContent=Rl,Jt=n(),r(pe.$$.fragment),bt=n(),v=i("div"),v.innerHTML=_l,Ut=n(),r(me.$$.fragment),wt=n(),re=i("p"),re.textContent=xl,Tt=n(),ce=i("p"),ce.textContent=Vl,Zt=n(),r(de.$$.fragment),jt=n(),Me=i("p"),Me.innerHTML=Yl,Wt=n(),r(ue.$$.fragment),Ct=n(),B=i("div"),B.innerHTML=Sl,vt=n(),ye=i("p"),ye.innerHTML=Fl,Bt=n(),r(fe.$$.fragment),Gt=n(),he=i("p"),he.textContent=$l,Nt=n(),r(ge.$$.fragment),It=n(),G=i("div"),G.innerHTML=Ql,kt=n(),r(Je.$$.fragment),Xt=n(),be=i("p"),be.innerHTML=El,Rt=n(),Ue=i("p"),Ue.innerHTML=Hl,_t=n(),r(N.$$.fragment),xt=n(),we=i("p"),we.innerHTML=zl,Vt=n(),r(Te.$$.fragment),Yt=n(),I=i("div"),I.innerHTML=Ll,St=n(),r(Ze.$$.fragment),Ft=n(),je=i("p"),je.innerHTML=Dl,$t=n(),We=i("p"),We.textContent=Al,Qt=n(),r(Ce.$$.fragment),Et=n(),k=i("div"),k.innerHTML=ql,Ht=n(),ve=i("p"),ve.innerHTML=Pl,zt=n(),r(Be.$$.fragment),Lt=n(),Ge=i("p"),Ge.textContent=Kl,Dt=n(),r(X.$$.fragment),At=n(),r(Ne.$$.fragment),qt=n(),R=i("div"),R.innerHTML=Ol,Pt=n(),Ie=i("p"),Ie.innerHTML=es,Kt=n(),r(ke.$$.fragment),Ot=n(),r(Xe.$$.fragment),el=n(),r(_.$$.fragment),tl=n(),Re=i("p"),Re.innerHTML=ts,ll=n(),_e=i("ol"),_e.innerHTML=ls,sl=n(),xe=i("p"),xe.textContent=ss,nl=n(),Ve=i("p"),Ve.textContent=ns,al=n(),r(Ye.$$.fragment),il=n(),x=i("div"),x.innerHTML=as,ol=n(),Se=i("p"),Se.textContent=is,pl=n(),r(Fe.$$.fragment),ml=n(),V=i("div"),V.innerHTML=os,rl=n(),$e=i("p"),$e.innerHTML=ps,cl=n(),r(Qe.$$.fragment),dl=n(),Ee=i("p"),Ee.textContent=ms,Ml=n(),r(He.$$.fragment),ul=n(),Y=i("div"),Y.innerHTML=rs,yl=n(),Le=i("p"),this.h()},l(e){const t=bs("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),f=o(e,"P",{}),ys(f).forEach(l),g=a(e),c(Z.$$.fragment,e),b=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1ersfq7"&&(w.textContent=Jl),De=a(e),c(j.$$.fragment,e),Ae=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-r7ehkq"&&(S.textContent=bl),qe=a(e),F=o(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-1jzb95l"&&(F.innerHTML=Ul),Pe=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-10jstxp"&&($.textContent=wl),Ke=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1rkzg2g"&&(Q.textContent=Tl),Oe=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-cwruts"&&(E.textContent=Zl),et=a(e),c(H.$$.fragment,e),tt=a(e),c(z.$$.fragment,e),lt=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1cb54q2"&&(L.textContent=jl),st=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-9znxu8"&&(D.innerHTML=Wl),nt=a(e),c(A.$$.fragment,e),at=a(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1jr9xr4"&&(W.innerHTML=Cl),it=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-11l20vy"&&(q.innerHTML=vl),ot=a(e),c(P.$$.fragment,e),pt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-17x9oax"&&(K.textContent=Bl),mt=a(e),c(O.$$.fragment,e),rt=a(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-3r1z1k"&&(C.innerHTML=Gl),ct=a(e),c(ee.$$.fragment,e),dt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-g01jh2"&&(te.textContent=Nl),Mt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1yt2phi"&&(le.innerHTML=Il),ut=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-9kkqfq"&&(se.innerHTML=kl),yt=a(e),c(ne.$$.fragment,e),ft=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1r135il"&&(ae.innerHTML=Xl),ht=a(e),c(ie.$$.fragment,e),gt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-wyr53z"&&(oe.textContent=Rl),Jt=a(e),c(pe.$$.fragment,e),bt=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-8qhhvs"&&(v.innerHTML=_l),Ut=a(e),c(me.$$.fragment,e),wt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1kuhqu5"&&(re.textContent=xl),Tt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-175mm0t"&&(ce.textContent=Vl),Zt=a(e),c(de.$$.fragment,e),jt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-4efl8b"&&(Me.innerHTML=Yl),Wt=a(e),c(ue.$$.fragment,e),Ct=a(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-grxw51"&&(B.innerHTML=Sl),vt=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-gxt08v"&&(ye.innerHTML=Fl),Bt=a(e),c(fe.$$.fragment,e),Gt=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-118t2qr"&&(he.textContent=$l),Nt=a(e),c(ge.$$.fragment,e),It=a(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-1qk6bz9"&&(G.innerHTML=Ql),kt=a(e),c(Je.$$.fragment,e),Xt=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-w08m5a"&&(be.innerHTML=El),Rt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-vnjl1j"&&(Ue.innerHTML=Hl),_t=a(e),c(N.$$.fragment,e),xt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-vqtz65"&&(we.innerHTML=zl),Vt=a(e),c(Te.$$.fragment,e),Yt=a(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-1hf21gv"&&(I.innerHTML=Ll),St=a(e),c(Ze.$$.fragment,e),Ft=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1f4xlrb"&&(je.innerHTML=Dl),$t=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-7i5g8g"&&(We.textContent=Al),Qt=a(e),c(Ce.$$.fragment,e),Et=a(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(k)!=="svelte-j8n5na"&&(k.innerHTML=ql),Ht=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-lfhg9v"&&(ve.innerHTML=Pl),zt=a(e),c(Be.$$.fragment,e),Lt=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-172pcgi"&&(Ge.textContent=Kl),Dt=a(e),c(X.$$.fragment,e),At=a(e),c(Ne.$$.fragment,e),qt=a(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-8vwtkd"&&(R.innerHTML=Ol),Pt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-qskk13"&&(Ie.innerHTML=es),Kt=a(e),c(ke.$$.fragment,e),Ot=a(e),c(Xe.$$.fragment,e),el=a(e),c(_.$$.fragment,e),tl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1engdvd"&&(Re.innerHTML=ts),ll=a(e),_e=o(e,"OL",{"data-svelte-h":!0}),p(_e)!=="svelte-18sf1v5"&&(_e.innerHTML=ls),sl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1gpdoop"&&(xe.textContent=ss),nl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1k4sivd"&&(Ve.textContent=ns),al=a(e),c(Ye.$$.fragment,e),il=a(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-1cl87j5"&&(x.innerHTML=as),ol=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-bab8ey"&&(Se.textContent=is),pl=a(e),c(Fe.$$.fragment,e),ml=a(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-1og8gmm"&&(V.innerHTML=os),rl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1olv4u3"&&($e.innerHTML=ps),cl=a(e),c(Qe.$$.fragment,e),dl=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-d5aph9"&&(Ee.textContent=ms),Ml=a(e),c(He.$$.fragment,e),ul=a(e),Y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Y)!=="svelte-1qlyggw"&&(Y.innerHTML=rs),yl=a(e),Le=o(e,"P",{}),ys(Le).forEach(l),this.h()},h(){U(m,"name","hf:doc:metadata"),U(m,"content",vs),U(W,"class","flex gap-4"),U(C,"class","flex justify-center"),U(v,"class","flex gap-4"),U(B,"class","flex gap-4"),U(G,"class","flex justify-center"),U(I,"class","flex gap-4"),U(k,"class","flex gap-4"),U(R,"class","flex justify-center"),U(x,"class","flex gap-4"),U(V,"class","flex gap-4"),U(Y,"class","flex justify-center")},m(e,t){Us(document.head,m),s(e,J,t),s(e,f,t),s(e,g,t),d(Z,e,t),s(e,b,t),s(e,w,t),s(e,De,t),d(j,e,t),s(e,Ae,t),s(e,S,t),s(e,qe,t),s(e,F,t),s(e,Pe,t),s(e,$,t),s(e,Ke,t),s(e,Q,t),s(e,Oe,t),s(e,E,t),s(e,et,t),d(H,e,t),s(e,tt,t),d(z,e,t),s(e,lt,t),s(e,L,t),s(e,st,t),s(e,D,t),s(e,nt,t),d(A,e,t),s(e,at,t),s(e,W,t),s(e,it,t),s(e,q,t),s(e,ot,t),d(P,e,t),s(e,pt,t),s(e,K,t),s(e,mt,t),d(O,e,t),s(e,rt,t),s(e,C,t),s(e,ct,t),d(ee,e,t),s(e,dt,t),s(e,te,t),s(e,Mt,t),s(e,le,t),s(e,ut,t),s(e,se,t),s(e,yt,t),d(ne,e,t),s(e,ft,t),s(e,ae,t),s(e,ht,t),d(ie,e,t),s(e,gt,t),s(e,oe,t),s(e,Jt,t),d(pe,e,t),s(e,bt,t),s(e,v,t),s(e,Ut,t),d(me,e,t),s(e,wt,t),s(e,re,t),s(e,Tt,t),s(e,ce,t),s(e,Zt,t),d(de,e,t),s(e,jt,t),s(e,Me,t),s(e,Wt,t),d(ue,e,t),s(e,Ct,t),s(e,B,t),s(e,vt,t),s(e,ye,t),s(e,Bt,t),d(fe,e,t),s(e,Gt,t),s(e,he,t),s(e,Nt,t),d(ge,e,t),s(e,It,t),s(e,G,t),s(e,kt,t),d(Je,e,t),s(e,Xt,t),s(e,be,t),s(e,Rt,t),s(e,Ue,t),s(e,_t,t),d(N,e,t),s(e,xt,t),s(e,we,t),s(e,Vt,t),d(Te,e,t),s(e,Yt,t),s(e,I,t),s(e,St,t),d(Ze,e,t),s(e,Ft,t),s(e,je,t),s(e,$t,t),s(e,We,t),s(e,Qt,t),d(Ce,e,t),s(e,Et,t),s(e,k,t),s(e,Ht,t),s(e,ve,t),s(e,zt,t),d(Be,e,t),s(e,Lt,t),s(e,Ge,t),s(e,Dt,t),d(X,e,t),s(e,At,t),d(Ne,e,t),s(e,qt,t),s(e,R,t),s(e,Pt,t),s(e,Ie,t),s(e,Kt,t),d(ke,e,t),s(e,Ot,t),d(Xe,e,t),s(e,el,t),d(_,e,t),s(e,tl,t),s(e,Re,t),s(e,ll,t),s(e,_e,t),s(e,sl,t),s(e,xe,t),s(e,nl,t),s(e,Ve,t),s(e,al,t),d(Ye,e,t),s(e,il,t),s(e,x,t),s(e,ol,t),s(e,Se,t),s(e,pl,t),d(Fe,e,t),s(e,ml,t),s(e,V,t),s(e,rl,t),s(e,$e,t),s(e,cl,t),d(Qe,e,t),s(e,dl,t),s(e,Ee,t),s(e,Ml,t),d(He,e,t),s(e,ul,t),s(e,Y,t),s(e,yl,t),s(e,Le,t),fl=!0},p(e,[t]){const cs={};t&2&&(cs.$$scope={dirty:t,ctx:e}),j.$set(cs);const ds={};t&2&&(ds.$$scope={dirty:t,ctx:e}),N.$set(ds);const Ms={};t&2&&(Ms.$$scope={dirty:t,ctx:e}),X.$set(Ms);const us={};t&2&&(us.$$scope={dirty:t,ctx:e}),_.$set(us)},i(e){fl||(M(Z.$$.fragment,e),M(j.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(Je.$$.fragment,e),M(N.$$.fragment,e),M(Te.$$.fragment,e),M(Ze.$$.fragment,e),M(Ce.$$.fragment,e),M(Be.$$.fragment,e),M(X.$$.fragment,e),M(Ne.$$.fragment,e),M(ke.$$.fragment,e),M(Xe.$$.fragment,e),M(_.$$.fragment,e),M(Ye.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M(He.$$.fragment,e),fl=!0)},o(e){u(Z.$$.fragment,e),u(j.$$.fragment,e),u(H.$$.fragment,e),u(z.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Je.$$.fragment,e),u(N.$$.fragment,e),u(Te.$$.fragment,e),u(Ze.$$.fragment,e),u(Ce.$$.fragment,e),u(Be.$$.fragment,e),u(X.$$.fragment,e),u(Ne.$$.fragment,e),u(ke.$$.fragment,e),u(Xe.$$.fragment,e),u(_.$$.fragment,e),u(Ye.$$.fragment,e),u(Fe.$$.fragment,e),u(Qe.$$.fragment,e),u(He.$$.fragment,e),fl=!1},d(e){e&&(l(J),l(f),l(g),l(b),l(w),l(De),l(Ae),l(S),l(qe),l(F),l(Pe),l($),l(Ke),l(Q),l(Oe),l(E),l(et),l(tt),l(lt),l(L),l(st),l(D),l(nt),l(at),l(W),l(it),l(q),l(ot),l(pt),l(K),l(mt),l(rt),l(C),l(ct),l(dt),l(te),l(Mt),l(le),l(ut),l(se),l(yt),l(ft),l(ae),l(ht),l(gt),l(oe),l(Jt),l(bt),l(v),l(Ut),l(wt),l(re),l(Tt),l(ce),l(Zt),l(jt),l(Me),l(Wt),l(Ct),l(B),l(vt),l(ye),l(Bt),l(Gt),l(he),l(Nt),l(It),l(G),l(kt),l(Xt),l(be),l(Rt),l(Ue),l(_t),l(xt),l(we),l(Vt),l(Yt),l(I),l(St),l(Ft),l(je),l($t),l(We),l(Qt),l(Et),l(k),l(Ht),l(ve),l(zt),l(Lt),l(Ge),l(Dt),l(At),l(qt),l(R),l(Pt),l(Ie),l(Kt),l(Ot),l(el),l(tl),l(Re),l(ll),l(_e),l(sl),l(xe),l(nl),l(Ve),l(al),l(il),l(x),l(ol),l(Se),l(pl),l(ml),l(V),l(rl),l($e),l(cl),l(dl),l(Ee),l(Ml),l(ul),l(Y),l(yl),l(Le)),l(m),y(Z,e),y(j,e),y(H,e),y(z,e),y(A,e),y(P,e),y(O,e),y(ee,e),y(ne,e),y(ie,e),y(pe,e),y(me,e),y(de,e),y(ue,e),y(fe,e),y(ge,e),y(Je,e),y(N,e),y(Te,e),y(Ze,e),y(Ce,e),y(Be,e),y(X,e),y(Ne,e),y(ke,e),y(Xe,e),y(_,e),y(Ye,e),y(Fe,e),y(Qe,e),y(He,e)}}}const vs='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Guess mode","local":"guess-mode","sections":[],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":3}],"depth":2}],"depth":1}';function Bs(T){return hs(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ws}),[]}class Rs extends gs{constructor(m){super(),Js(this,m,Bs,Cs,fs,{})}}export{Rs as component};
