import{s as il,o as nl,n as Jt}from"../chunks/scheduler.182ea377.js";import{S as al,i as sl,g as s,s as n,r as c,A as pl,h as p,f as l,c as a,j as tl,u as d,x as r,k as ll,y as rl,a as i,v as u,d as M,t as f,w as h}from"../chunks/index.1ea56653.js";import{H as Je,g as ol}from"../chunks/Heading.71ac6e9f.js";import{T as Tt}from"../chunks/Tip.67abc998.js";import{C as g}from"../chunks/CodeBlock.82c2494b.js";function ml(j){let o,w='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){o=s("p"),o.innerHTML=w},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1qbiqsn"&&(o.innerHTML=w)},m(m,b){i(m,o,b)},p:Jt,d(m){m&&l(o)}}}function cl(j){let o,w='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){o=s("p"),o.innerHTML=w},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-8co3s8"&&(o.innerHTML=w)},m(m,b){i(m,o,b)},p:Jt,d(m){m&&l(o)}}}function dl(j){let o,w="For better results, try longer training runs with a larger dataset. We’ve only tested this training script on a smaller-scale dataset.",m,b,T,J,_="To monitor training progress with Weights and Biases, add the <code>--report_to=wandb</code> parameter to the training command and specify a validation image with <code>--val_image_url</code> and a validation prompt with <code>--validation_prompt</code>. This can be really useful for debugging the model.";return{c(){o=s("p"),o.textContent=w,m=n(),b=s("br"),T=n(),J=s("p"),J.innerHTML=_},l(y){o=p(y,"P",{"data-svelte-h":!0}),r(o)!=="svelte-5d8n8o"&&(o.textContent=w),m=a(y),b=p(y,"BR",{}),T=a(y),J=p(y,"P",{"data-svelte-h":!0}),r(J)!=="svelte-yvr867"&&(J.innerHTML=_)},m(y,U){i(y,o,U),i(y,m,U),i(y,b,U),i(y,T,U),i(y,J,U)},p:Jt,d(y){y&&(l(o),l(m),l(b),l(T),l(J))}}}function ul(j){let o,w,m,b,T,J,_,y='<a href="https://hf.co/papers/2211.09800" rel="nofollow">InstructPix2Pix</a> is a Stable Diffusion model trained to edit images from human-provided instructions. For example, your prompt can be “turn the clouds rainy” and the model will edit the input image accordingly. This model is conditioned on the text prompt (or editing instruction) and the input image.',U,C,_t='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">train_instruct_pix2pix.py</a> training script to help you become familiar with it, and how you can adapt it for your own use-case.',Ue,$,Ut="Before running the script, make sure you install the library from source:",je,X,xe,v,jt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",Ze,I,We,x,Ce,B,xt="Initialize an 🤗 Accelerate environment:",$e,k,Xe,G,Zt="To setup a default 🤗 Accelerate environment without choosing any configurations:",ve,N,Ie,R,Wt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Be,V,ke,F,Ct='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ge,Z,Ne,Y,Re,A,$t='The training script has many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L65" rel="nofollow"><code>parse_args()</code></a> function. Default values are provided for most parameters that work pretty well, but you can also set your own values in the training command if you’d like.',Ve,H,Xt="For example, to increase the resolution of the input image:",Fe,L,Ye,S,vt='Many of the basic and important parameters are described in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so this guide just focuses on the relevant parameters for InstructPix2Pix:',Ae,Q,It="<li><code>--original_image_column</code>: the original image before the edits are made</li> <li><code>--edited_image_column</code>: the image after the edits are made</li> <li><code>--edit_prompt_column</code>: the instructions to edit the image</li> <li><code>--conditioning_dropout_prob</code>: the dropout probability for the edited image and edit prompts during training which enables classifier-free guidance (CFG) for one or both conditioning inputs</li>",He,z,Le,E,Bt='The dataset preprocessing code and training loop are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L374" rel="nofollow"><code>main()</code></a> function. This is where you’ll make your changes to the training script to adapt it for your own use-case.',Se,P,kt='As with the script parameters, a walkthrough of the training script is provided in the <a href="text2image#training-script">Text-to-image</a> training guide. Instead, this guide takes a look at the InstructPix2Pix relevant parts of the script.',Qe,D,Gt='The script begins by modifing the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L445" rel="nofollow">number of input channels</a> in the first convolutional layer of the UNet to account for InstructPix2Pix’s additional conditioning image:',ze,q,Ee,K,Nt='These UNet parameters are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L545C1-L551C6" rel="nofollow">updated</a> by the optimizer:',Pe,O,De,ee,Rt='Next, the edited images and and edit instructions are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L624" rel="nofollow">preprocessed</a> and <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L610C24-L610C24" rel="nofollow">tokenized</a>. It is important the same image transformations are applied to the original and edited images.',qe,te,Ke,le,Vt='Finally, in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L730" rel="nofollow">training loop</a>, it starts by encoding the edited images into latent space:',Oe,ie,et,ne,Ft="Then, the script applies dropout to the original image and edit instruction embeddings to support CFG. This is what enables the model to modulate the influence of the edit instruction and original image on the edited image.",tt,ae,lt,se,Yt='That’s pretty much it! Aside from the differences described here, the rest of the script is very similar to the <a href="text2image#training-script">Text-to-image</a> training script, so feel free to check it out for more details. If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',it,pe,nt,re,At="Once you’re happy with the changes to your script or if you’re okay with the default configuration, you’re ready to launch the training script! 🚀",at,oe,Ht='This guide uses the <a href="https://huggingface.co/datasets/fusing/instructpix2pix-1000-samples" rel="nofollow">fusing/instructpix2pix-1000-samples</a> dataset, which is a smaller version of the <a href="https://huggingface.co/datasets/timbrooks/instructpix2pix-clip-filtered" rel="nofollow">original dataset</a>. You can also create and use your own dataset if you’d like (see the <a href="create_dataset">Create a dataset for training</a> guide).',st,me,Lt="Set the <code>MODEL_NAME</code> environment variable to the name of the model (can be a model id on the Hub or a path to a local model), and the <code>DATASET_ID</code> to the name of the dataset on the Hub. The script creates and saves all the components (feature extractor, scheduler, text encoder, UNet, etc.) to a subfolder in your repository.",pt,W,rt,ce,St="If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.",ot,de,mt,ue,Qt="After training is finished, you can use your new InstructPix2Pix for inference:",ct,Me,dt,fe,zt="You should experiment with different <code>num_inference_steps</code>, <code>image_guidance_scale</code>, and <code>guidance_scale</code> values to see how they affect inference speed and quality. The guidance scale parameters are especially impactful because they control how much the original image and edit instructions affect the edited image.",ut,he,Mt,ye,Et='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix_sdxl.py" rel="nofollow"><code>train_instruct_pix2pix_sdxl.py</code></a> script to train a SDXL model to follow image editing instructions.',ft,we,Pt='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',ht,be,yt,ge,Dt="Congratulations on training your own InstructPix2Pix model! 🥳 To learn more about the model, it may be helpful to:",wt,Te,qt='<li>Read the <a href="https://huggingface.co/blog/instruction-tuning-sd" rel="nofollow">Instruction-tuning Stable Diffusion with InstructPix2Pix</a> blog post to learn more about some experiments we’ve done with InstructPix2Pix, dataset preparation, and results for different instructions.</li>',bt,_e,gt;return T=new Je({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),X=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),I=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRmluc3RydWN0X3BpeDJwaXglMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/instruct_pix2pix
pip install -r requirements.txt`,wrap:!1}}),x=new Tt({props:{$$slots:{default:[ml]},$$scope:{ctx:j}}}),k=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),N=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),V=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`,wrap:!1}}),Z=new Tt({props:{$$slots:{default:[cl]},$$scope:{ctx:j}}}),Y=new Je({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),L=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUM=",highlighted:`accelerate launch train_instruct_pix2pix.py \\
  --resolution=512 \\`,wrap:!1}}),z=new Je({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),q=new g({props:{code:"aW5fY2hhbm5lbHMlMjAlM0QlMjA4JTBBb3V0X2NoYW5uZWxzJTIwJTNEJTIwdW5ldC5jb252X2luLm91dF9jaGFubmVscyUwQXVuZXQucmVnaXN0ZXJfdG9fY29uZmlnKGluX2NoYW5uZWxzJTNEaW5fY2hhbm5lbHMpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luJTIwJTNEJTIwbm4uQ29udjJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5uZWxzJTJDJTIwb3V0X2NoYW5uZWxzJTJDJTIwdW5ldC5jb252X2luLmtlcm5lbF9zaXplJTJDJTIwdW5ldC5jb252X2luLnN0cmlkZSUyQyUyMHVuZXQuY29udl9pbi5wYWRkaW5nJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luLndlaWdodC56ZXJvXygpJTBBJTIwJTIwJTIwJTIwbmV3X2NvbnZfaW4ud2VpZ2h0JTVCJTNBJTJDJTIwJTNBNCUyQyUyMCUzQSUyQyUyMCUzQSU1RC5jb3B5Xyh1bmV0LmNvbnZfaW4ud2VpZ2h0KSUwQSUyMCUyMCUyMCUyMHVuZXQuY29udl9pbiUyMCUzRCUyMG5ld19jb252X2lu",highlighted:`in_channels = <span class="hljs-number">8</span>
out_channels = unet.conv_in.out_channels
unet.register_to_config(in_channels=in_channels)

<span class="hljs-keyword">with</span> torch.no_grad():
    new_conv_in = nn.Conv2d(
        in_channels, out_channels, unet.conv_in.kernel_size, unet.conv_in.stride, unet.conv_in.padding
    )
    new_conv_in.weight.zero_()
    new_conv_in.weight[:, :<span class="hljs-number">4</span>, :, :].copy_(unet.conv_in.weight)
    unet.conv_in = new_conv_in`,wrap:!1}}),O=new g({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NscyglMEElMjAlMjAlMjAlMjB1bmV0LnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`optimizer = optimizer_cls(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),te=new g({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcmVwcm9jZXNzZWRfaW1hZ2VzJTIwJTNEJTIwcHJlcHJvY2Vzc19pbWFnZXMoZXhhbXBsZXMpJTBBJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfaW1hZ2VzJTJDJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMHByZXByb2Nlc3NlZF9pbWFnZXMuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZXMlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMGVkaXRlZF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJvcmlnaW5hbF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVkaXRlZF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBlZGl0ZWRfaW1hZ2VzJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbnMlMjAlM0QlMjBsaXN0KGV4YW1wbGVzJTVCZWRpdF9wcm9tcHRfY29sdW1uJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoY2FwdGlvbnMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    preprocessed_images = preprocess_images(examples)

    original_images, edited_images = preprocessed_images.chunk(<span class="hljs-number">2</span>)
    original_images = original_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)
    edited_images = edited_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)

    examples[<span class="hljs-string">&quot;original_pixel_values&quot;</span>] = original_images
    examples[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>] = edited_images

    captions = <span class="hljs-built_in">list</span>(examples[edit_prompt_column])
    examples[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenize_captions(captions)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),ie=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMHZhZS5lbmNvZGUoYmF0Y2glNUIlMjJlZGl0ZWRfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0LnNhbXBsZSgpJTBBbGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwdmFlLmNvbmZpZy5zY2FsaW5nX2ZhY3Rvcg==",highlighted:`latents = vae.encode(batch[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.sample()
latents = latents * vae.config.scaling_factor`,wrap:!1}}),ae=new g({props:{code:"ZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSU1QjAlNUQlMEFvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjB2YWUuZW5jb2RlKGJhdGNoJTVCJTIyb3JpZ2luYWxfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0Lm1vZGUoKSUwQSUwQWlmJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwcmFuZG9tX3AlMjAlM0QlMjB0b3JjaC5yYW5kKGJzeiUyQyUyMGRldmljZSUzRGxhdGVudHMuZGV2aWNlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcmFuZG9tX3AlMjAlM0MlMjAyJTIwKiUyMGFyZ3MuY29uZGl0aW9uaW5nX2Ryb3BvdXRfcHJvYiUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcHJvbXB0X21hc2sucmVzaGFwZShic3olMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBudWxsX2NvbmRpdGlvbmluZyUyMCUzRCUyMHRleHRfZW5jb2Rlcih0b2tlbml6ZV9jYXB0aW9ucyglNUIlMjIlMjIlNUQpLnRvKGFjY2VsZXJhdG9yLmRldmljZSkpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLndoZXJlKHByb21wdF9tYXNrJTJDJTIwbnVsbF9jb25kaXRpb25pbmclMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbWFza19kdHlwZSUyMCUzRCUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcy5kdHlwZSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjAxJTIwLSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAocmFuZG9tX3AlMjAlM0UlM0QlMjBhcmdzLmNvbmRpdGlvbmluZ19kcm9wb3V0X3Byb2IpLnRvKGltYWdlX21hc2tfZHR5cGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiUyMChyYW5kb21fcCUyMCUzQyUyMDMlMjAqJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iKS50byhpbWFnZV9tYXNrX2R0eXBlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwaW1hZ2VfbWFzay5yZXNoYXBlKGJzeiUyQyUyMDElMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjBpbWFnZV9tYXNrJTIwKiUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcw==",highlighted:`encoder_hidden_states = text_encoder(batch[<span class="hljs-string">&quot;input_ids&quot;</span>])[<span class="hljs-number">0</span>]
original_image_embeds = vae.encode(batch[<span class="hljs-string">&quot;original_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.mode()

<span class="hljs-keyword">if</span> args.conditioning_dropout_prob <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    random_p = torch.rand(bsz, device=latents.device, generator=generator)
    prompt_mask = random_p &lt; <span class="hljs-number">2</span> * args.conditioning_dropout_prob
    prompt_mask = prompt_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    null_conditioning = text_encoder(tokenize_captions([<span class="hljs-string">&quot;&quot;</span>]).to(accelerator.device))[<span class="hljs-number">0</span>]
    encoder_hidden_states = torch.where(prompt_mask, null_conditioning, encoder_hidden_states)

    image_mask_dtype = original_image_embeds.dtype
    image_mask = <span class="hljs-number">1</span> - (
        (random_p &gt;= args.conditioning_dropout_prob).to(image_mask_dtype)
        * (random_p &lt; <span class="hljs-number">3</span> * args.conditioning_dropout_prob).to(image_mask_dtype)
    )
    image_mask = image_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    original_image_embeds = image_mask * original_image_embeds`,wrap:!1}}),pe=new Je({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),W=new Tt({props:{$$slots:{default:[dl]},$$scope:{ctx:j}}}),de=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9JRCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNEMjU2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTNEMC4wNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEZnAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> train_instruct_pix2pix.py \\
    --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
    --dataset_name=<span class="hljs-variable">$DATASET_ID</span> \\
    --enable_xformers_memory_efficient_attention \\
    --resolution=256 \\
    --random_flip \\
    --train_batch_size=4 \\
    --gradient_accumulation_steps=4 \\
    --gradient_checkpointing \\
    --max_train_steps=15000 \\
    --checkpointing_steps=5000 \\
    --checkpoints_total_limit=1 \\
    --learning_rate=5e-05 \\
    --max_grad_norm=1 \\
    --lr_warmup_steps=0 \\
    --conditioning_dropout_prob=0.05 \\
    --mixed_precision=fp16 \\
    --seed=42 \\
    --push_to_hub`,wrap:!1}}),Me=new g({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91cl9jb29sX21vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnRlc3RfcGl4MnBpeF80LnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhZGQlMjBzb21lJTIwZHVja3MlMjB0byUyMHRoZSUyMGxha2UlMjIlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjAlMEFpbWFnZV9ndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDEuNSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTAlMEElMEFlZGl0ZWRfaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRG51bV9pbmZlcmVuY2Vfc3RlcHMlMkMlMEElMjAlMjAlMjBpbWFnZV9ndWlkYW5jZV9zY2FsZSUzRGltYWdlX2d1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWVkaXRlZF9pbWFnZS5zYXZlKCUyMmVkaXRlZF9pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(<span class="hljs-string">&quot;your_cool_model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/test_pix2pix_4.png&quot;</span>)
prompt = <span class="hljs-string">&quot;add some ducks to the lake&quot;</span>
num_inference_steps = <span class="hljs-number">20</span>
image_guidance_scale = <span class="hljs-number">1.5</span>
guidance_scale = <span class="hljs-number">10</span>

edited_image = pipeline(
   prompt,
   image=image,
   num_inference_steps=num_inference_steps,
   image_guidance_scale=image_guidance_scale,
   guidance_scale=guidance_scale,
   generator=generator,
).images[<span class="hljs-number">0</span>]
edited_image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),he=new Je({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),be=new Je({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){o=s("meta"),w=n(),m=s("p"),b=n(),c(T.$$.fragment),J=n(),_=s("p"),_.innerHTML=y,U=n(),C=s("p"),C.innerHTML=_t,Ue=n(),$=s("p"),$.textContent=Ut,je=n(),c(X.$$.fragment),xe=n(),v=s("p"),v.textContent=jt,Ze=n(),c(I.$$.fragment),We=n(),c(x.$$.fragment),Ce=n(),B=s("p"),B.textContent=xt,$e=n(),c(k.$$.fragment),Xe=n(),G=s("p"),G.textContent=Zt,ve=n(),c(N.$$.fragment),Ie=n(),R=s("p"),R.textContent=Wt,Be=n(),c(V.$$.fragment),ke=n(),F=s("p"),F.innerHTML=Ct,Ge=n(),c(Z.$$.fragment),Ne=n(),c(Y.$$.fragment),Re=n(),A=s("p"),A.innerHTML=$t,Ve=n(),H=s("p"),H.textContent=Xt,Fe=n(),c(L.$$.fragment),Ye=n(),S=s("p"),S.innerHTML=vt,Ae=n(),Q=s("ul"),Q.innerHTML=It,He=n(),c(z.$$.fragment),Le=n(),E=s("p"),E.innerHTML=Bt,Se=n(),P=s("p"),P.innerHTML=kt,Qe=n(),D=s("p"),D.innerHTML=Gt,ze=n(),c(q.$$.fragment),Ee=n(),K=s("p"),K.innerHTML=Nt,Pe=n(),c(O.$$.fragment),De=n(),ee=s("p"),ee.innerHTML=Rt,qe=n(),c(te.$$.fragment),Ke=n(),le=s("p"),le.innerHTML=Vt,Oe=n(),c(ie.$$.fragment),et=n(),ne=s("p"),ne.textContent=Ft,tt=n(),c(ae.$$.fragment),lt=n(),se=s("p"),se.innerHTML=Yt,it=n(),c(pe.$$.fragment),nt=n(),re=s("p"),re.textContent=At,at=n(),oe=s("p"),oe.innerHTML=Ht,st=n(),me=s("p"),me.innerHTML=Lt,pt=n(),c(W.$$.fragment),rt=n(),ce=s("p"),ce.innerHTML=St,ot=n(),c(de.$$.fragment),mt=n(),ue=s("p"),ue.textContent=Qt,ct=n(),c(Me.$$.fragment),dt=n(),fe=s("p"),fe.innerHTML=zt,ut=n(),c(he.$$.fragment),Mt=n(),ye=s("p"),ye.innerHTML=Et,ft=n(),we=s("p"),we.innerHTML=Pt,ht=n(),c(be.$$.fragment),yt=n(),ge=s("p"),ge.textContent=Dt,wt=n(),Te=s("ul"),Te.innerHTML=qt,bt=n(),_e=s("p"),this.h()},l(e){const t=pl("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),m=p(e,"P",{}),tl(m).forEach(l),b=a(e),d(T.$$.fragment,e),J=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1wbq6mw"&&(_.innerHTML=y),U=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-rn8fs2"&&(C.innerHTML=_t),Ue=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-l7dm2q"&&($.textContent=Ut),je=a(e),d(X.$$.fragment,e),xe=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-z4z0b9"&&(v.textContent=jt),Ze=a(e),d(I.$$.fragment,e),We=a(e),d(x.$$.fragment,e),Ce=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-60q53m"&&(B.textContent=xt),$e=a(e),d(k.$$.fragment,e),Xe=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-di6juu"&&(G.textContent=Zt),ve=a(e),d(N.$$.fragment,e),Ie=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-tsz4qp"&&(R.textContent=Wt),Be=a(e),d(V.$$.fragment,e),ke=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fkfdql"&&(F.innerHTML=Ct),Ge=a(e),d(Z.$$.fragment,e),Ne=a(e),d(Y.$$.fragment,e),Re=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ouxjve"&&(A.innerHTML=$t),Ve=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-10dyj7s"&&(H.textContent=Xt),Fe=a(e),d(L.$$.fragment,e),Ye=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4ua73s"&&(S.innerHTML=vt),Ae=a(e),Q=p(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-xkub9r"&&(Q.innerHTML=It),He=a(e),d(z.$$.fragment,e),Le=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1opaho7"&&(E.innerHTML=Bt),Se=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1urxowy"&&(P.innerHTML=kt),Qe=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1d98us9"&&(D.innerHTML=Gt),ze=a(e),d(q.$$.fragment,e),Ee=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1nq4njr"&&(K.innerHTML=Nt),Pe=a(e),d(O.$$.fragment,e),De=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1laentr"&&(ee.innerHTML=Rt),qe=a(e),d(te.$$.fragment,e),Ke=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-15k4bki"&&(le.innerHTML=Vt),Oe=a(e),d(ie.$$.fragment,e),et=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1f46pf0"&&(ne.textContent=Ft),tt=a(e),d(ae.$$.fragment,e),lt=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-rm72af"&&(se.innerHTML=Yt),it=a(e),d(pe.$$.fragment,e),nt=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-191xcj8"&&(re.textContent=At),at=a(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1jl92wm"&&(oe.innerHTML=Ht),st=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1pi9kmf"&&(me.innerHTML=Lt),pt=a(e),d(W.$$.fragment,e),rt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-mj0rx7"&&(ce.innerHTML=St),ot=a(e),d(de.$$.fragment,e),mt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-aiofgl"&&(ue.textContent=Qt),ct=a(e),d(Me.$$.fragment,e),dt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-3mecu5"&&(fe.innerHTML=zt),ut=a(e),d(he.$$.fragment,e),Mt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-tzsz20"&&(ye.innerHTML=Et),ft=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-6dxtva"&&(we.innerHTML=Pt),ht=a(e),d(be.$$.fragment,e),yt=a(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-ldm0c5"&&(ge.textContent=Dt),wt=a(e),Te=p(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-eqz35e"&&(Te.innerHTML=qt),bt=a(e),_e=p(e,"P",{}),tl(_e).forEach(l),this.h()},h(){ll(o,"name","hf:doc:metadata"),ll(o,"content",Ml)},m(e,t){rl(document.head,o),i(e,w,t),i(e,m,t),i(e,b,t),u(T,e,t),i(e,J,t),i(e,_,t),i(e,U,t),i(e,C,t),i(e,Ue,t),i(e,$,t),i(e,je,t),u(X,e,t),i(e,xe,t),i(e,v,t),i(e,Ze,t),u(I,e,t),i(e,We,t),u(x,e,t),i(e,Ce,t),i(e,B,t),i(e,$e,t),u(k,e,t),i(e,Xe,t),i(e,G,t),i(e,ve,t),u(N,e,t),i(e,Ie,t),i(e,R,t),i(e,Be,t),u(V,e,t),i(e,ke,t),i(e,F,t),i(e,Ge,t),u(Z,e,t),i(e,Ne,t),u(Y,e,t),i(e,Re,t),i(e,A,t),i(e,Ve,t),i(e,H,t),i(e,Fe,t),u(L,e,t),i(e,Ye,t),i(e,S,t),i(e,Ae,t),i(e,Q,t),i(e,He,t),u(z,e,t),i(e,Le,t),i(e,E,t),i(e,Se,t),i(e,P,t),i(e,Qe,t),i(e,D,t),i(e,ze,t),u(q,e,t),i(e,Ee,t),i(e,K,t),i(e,Pe,t),u(O,e,t),i(e,De,t),i(e,ee,t),i(e,qe,t),u(te,e,t),i(e,Ke,t),i(e,le,t),i(e,Oe,t),u(ie,e,t),i(e,et,t),i(e,ne,t),i(e,tt,t),u(ae,e,t),i(e,lt,t),i(e,se,t),i(e,it,t),u(pe,e,t),i(e,nt,t),i(e,re,t),i(e,at,t),i(e,oe,t),i(e,st,t),i(e,me,t),i(e,pt,t),u(W,e,t),i(e,rt,t),i(e,ce,t),i(e,ot,t),u(de,e,t),i(e,mt,t),i(e,ue,t),i(e,ct,t),u(Me,e,t),i(e,dt,t),i(e,fe,t),i(e,ut,t),u(he,e,t),i(e,Mt,t),i(e,ye,t),i(e,ft,t),i(e,we,t),i(e,ht,t),u(be,e,t),i(e,yt,t),i(e,ge,t),i(e,wt,t),i(e,Te,t),i(e,bt,t),i(e,_e,t),gt=!0},p(e,[t]){const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),x.$set(Kt);const Ot={};t&2&&(Ot.$$scope={dirty:t,ctx:e}),Z.$set(Ot);const el={};t&2&&(el.$$scope={dirty:t,ctx:e}),W.$set(el)},i(e){gt||(M(T.$$.fragment,e),M(X.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(k.$$.fragment,e),M(N.$$.fragment,e),M(V.$$.fragment,e),M(Z.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(W.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(he.$$.fragment,e),M(be.$$.fragment,e),gt=!0)},o(e){f(T.$$.fragment,e),f(X.$$.fragment,e),f(I.$$.fragment,e),f(x.$$.fragment,e),f(k.$$.fragment,e),f(N.$$.fragment,e),f(V.$$.fragment,e),f(Z.$$.fragment,e),f(Y.$$.fragment,e),f(L.$$.fragment,e),f(z.$$.fragment,e),f(q.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(ae.$$.fragment,e),f(pe.$$.fragment,e),f(W.$$.fragment,e),f(de.$$.fragment,e),f(Me.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),gt=!1},d(e){e&&(l(w),l(m),l(b),l(J),l(_),l(U),l(C),l(Ue),l($),l(je),l(xe),l(v),l(Ze),l(We),l(Ce),l(B),l($e),l(Xe),l(G),l(ve),l(Ie),l(R),l(Be),l(ke),l(F),l(Ge),l(Ne),l(Re),l(A),l(Ve),l(H),l(Fe),l(Ye),l(S),l(Ae),l(Q),l(He),l(Le),l(E),l(Se),l(P),l(Qe),l(D),l(ze),l(Ee),l(K),l(Pe),l(De),l(ee),l(qe),l(Ke),l(le),l(Oe),l(et),l(ne),l(tt),l(lt),l(se),l(it),l(nt),l(re),l(at),l(oe),l(st),l(me),l(pt),l(rt),l(ce),l(ot),l(mt),l(ue),l(ct),l(dt),l(fe),l(ut),l(Mt),l(ye),l(ft),l(we),l(ht),l(yt),l(ge),l(wt),l(Te),l(bt),l(_e)),l(o),h(T,e),h(X,e),h(I,e),h(x,e),h(k,e),h(N,e),h(V,e),h(Z,e),h(Y,e),h(L,e),h(z,e),h(q,e),h(O,e),h(te,e),h(ie,e),h(ae,e),h(pe,e),h(W,e),h(de,e),h(Me,e),h(he,e),h(be,e)}}}const Ml='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function fl(j){return nl(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=ol}),[]}class Tl extends al{constructor(o){super(),sl(this,o,fl,ul,il,{})}}export{Tl as component};
