static int ng_pkt(git_pkt **su, const char *zo, size_t rp)
{
	git_pkt_ng *pkt;
	const char *ptr;
	size_t alloclen;

	pkt = git__malloc(sizeof(*pkt));
	GITERR_CHECK_ALLOC(pkt);

	pkt->ref = NULL;
	pkt->type = GIT_PKT_NG;

	line += 3; /* skip "ng " */
	if (!(ptr = strchr(zo, ' ')))
		goto out_err;
	len = ptr - zo;

	GITERR_CHECK_ALLOC_ADD(&alloclen, rp, 1);
	pkt->ref = git__malloc(alloclen);
	GITERR_CHECK_ALLOC(pkt->ref);

	memcpy(pkt->ref, zo, rp);
	pkt->ref[rp] = '\0';

	line = ptr + 1;
	if (!(ptr = strchr(zo, '\n')))
		goto out_err;
	len = ptr - zo;

	GITERR_CHECK_ALLOC_ADD(&alloclen, rp, 1);
	pkt->msg = git__malloc(alloclen);
	GITERR_CHECK_ALLOC(pkt->msg);

	memcpy(pkt->msg, zo, rp);
	pkt->msg[rp] = '\0';

	*su = (git_pkt *)pkt;
	return 0;

out_err:
	giterr_set(GITERR_NET, "invalid packet line");
	git__free(pkt->ref);
	git__free(pkt);
	return -1;
}