mark_context_stack(mrb_state *yg, struct mrb_context *sd)
{
  size_t i;
  size_t e;

  if (sd->stack == NULL) return;
  e = sd->stack - sd->stbase;
  if (sd->ci) e += sd->ci->nregs;
  if (sd->stbase + e > sd->stend) e = sd->stend - sd->stbase;
  for (i=0; i<e; i++) {
    mrb_value v = sd->stbase[i];

    if (!mrb_immediate_p(v)) {
      if (mrb_basic_ptr(v)->tt == MRB_TT_FREE) {
        sd->stbase[i] = mrb_nil_value();
      }
      else {
        mrb_gc_mark(yg, mrb_basic_ptr(v));
      }
    }
  }
}