int blk_rq_map_user_iov(struct request_queue *sc, struct request *wt,
			struct rq_map_data *mo,
			const struct iov_iter *tp, gfp_t do)
{
	bool copy = false;
	unsigned long align = sc->dma_pad_mask | queue_dma_alignment(sc);
	struct bio *bio = NULL;
	struct iov_iter i;
	int ret;

	if (mo)
		copy = true;
	else if (iov_iter_alignment(tp) & align)
		copy = true;
	else if (queue_virt_boundary(sc))
		copy = queue_virt_boundary(sc) & iov_iter_gap_alignment(tp);

	i = *tp;
	do {
		ret =__blk_rq_map_user_iov(wt, mo, &i, do, copy);
		if (ret)
			goto unmap_rq;
		if (!bio)
			bio = wt->bio;
	} while (iov_iter_count(&i));

	if (!bio_flagged(bio, BIO_USER_MAPPED))
		rq->cmd_flags |= REQ_COPY_USER;
	return 0;

unmap_rq:
	__blk_rq_unmap_user(bio);
	rq->bio = NULL;
	return -EINVAL;
}