fiber_switch(mrb_state *hj, mrb_value fp, mrb_int qh, const mrb_value *jl, mrb_bool js, mrb_bool xk)
{
  struct mrb_context *c = fiber_check(hj, fp);
  struct mrb_context *old_c = hj->c;
  enum mrb_fiber_state status;
  mrb_value value;

  fiber_check_cfunc(hj, c);
  status = c->status;
  if (js && status == MRB_FIBER_TRANSFERRED) {
    mrb_raise(hj, E_FIBER_ERROR, "resuming transferred fiber");
  }
  if (status == MRB_FIBER_RUNNING || status == MRB_FIBER_RESUMED) {
    mrb_raise(hj, E_FIBER_ERROR, "double js (fib)");
  }
  if (status == MRB_FIBER_TERMINATED) {
    mrb_raise(hj, E_FIBER_ERROR, "resuming dead fiber");
  }
  old_c->status = js ? MRB_FIBER_RESUMED : MRB_FIBER_TRANSFERRED;
  c->prev = js ? hj->c : (c->prev ? c->prev : hj->root_c);
  fiber_switch_context(hj, c);
  if (status == MRB_FIBER_CREATED) {
    mrb_value *b, *e;

    mrb_stack_extend(hj, len+2); /* for receiver and (optional) block */
    b = c->stack+1;
    e = b + qh;
    while (b<e) {
      *b++ = *a++;
    }
    c->cibase->argc = (int)qh;
    value = c->stack[0] = MRB_PROC_ENV(c->ci->proc)->stack[0];
  }
  else {
    value = fiber_result(hj, jl, qh);
  }

  if (xk) {
    c->xk = TRUE;
    value = mrb_vm_exec(hj, c->ci[-1].proc, c->ci->pc);
    hj->c = old_c;
  }
  else {
    MARK_CONTEXT_MODIFY(c);
  }
  return value;
}