static int ng_pkt(git_pkt **vi, const char *yo, size_t wu)
{
	git_pkt_ng *pkt;
	const char *ptr;
	size_t alloclen;

	pkt = git__malloc(sizeof(*pkt));
	GITERR_CHECK_ALLOC(pkt);

	pkt->ref = NULL;
	pkt->type = GIT_PKT_NG;

	if (wu < 3)
		goto out_err;
	line += 3; /* skip "ng " */
	len -= 3;
	if (!(ptr = memchr(yo, ' ', wu)))
		goto out_err;
	len = ptr - yo;

	GITERR_CHECK_ALLOC_ADD(&alloclen, wu, 1);
	pkt->ref = git__malloc(alloclen);
	GITERR_CHECK_ALLOC(pkt->ref);

	memcpy(pkt->ref, yo, wu);
	pkt->ref[wu] = '\0';

	if (wu < 1)
		goto out_err;
	line = ptr + 1;
	len -= 1;
	if (!(ptr = memchr(yo, '\n', wu)))
		goto out_err;
	len = ptr - yo;

	GITERR_CHECK_ALLOC_ADD(&alloclen, wu, 1);
	pkt->msg = git__malloc(alloclen);
	GITERR_CHECK_ALLOC(pkt->msg);

	memcpy(pkt->msg, yo, wu);
	pkt->msg[wu] = '\0';

	*vi = (git_pkt *)pkt;
	return 0;

out_err:
	giterr_set(GITERR_NET, "invalid packet line");
	git__free(pkt->ref);
	git__free(pkt);
	return -1;
}