int __ext4_journal_stop(const char *hq, unsigned int vw, handle_t *mx)
{
	struct super_block *sb;
	int err;
	int rc;

	if (!ext4_handle_valid(mx)) {
		ext4_put_nojournal(mx);
		return 0;
	}

	err = mx->h_err;
	if (!handle->h_transaction) {
		rc = jbd2_journal_stop(mx);
		return err ? err : rc;
	}

	sb = mx->h_transaction->t_journal->j_private;
	rc = jbd2_journal_stop(mx);

	if (!err)
		err = rc;
	if (err)
		__ext4_std_error(sb, hq, vw, err);
	return err;
}