//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: happy
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include <ctype.h>

#define MIN_PASSWORD_LENGTH 8
#define MAX_PASSWORD_LENGTH 32

bool is_valid_password(char* password) {
    int length = strlen(password);
    if (length < MIN_PASSWORD_LENGTH || length > MAX_PASSWORD_LENGTH) {
        return false;
    }

    bool has_uppercase = false;
    bool has_lowercase = false;
    bool has_number = false;
    bool has_special_character = false;

    for (int i = 0; i < length; i++) {
        char c = tolower(password[i]);
        if (c >= 'a' && c <= 'z') {
            has_lowercase = true;
        } else if (c >= 'A' && c <= 'Z') {
            has_uppercase = true;
        } else if (c >= '0' && c <= '9') {
            has_number = true;
        } else if (c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '&' || c == '*') {
            has_special_character = true;
        }
    }

    if (!has_uppercase ||!has_lowercase ||!has_number ||!has_special_character) {
        return false;
    }

    return true;
}

int main() {
    char password[MAX_PASSWORD_LENGTH];
    printf("Enter your password: ");
    fgets(password, MAX_PASSWORD_LENGTH, stdin);
    password[strcspn(password, "\n")] = '\0';

    if (is_valid_password(password)) {
        printf("Your password is strong!\n");
    } else {
        printf("Your password is weak.\n");
    }

    return 0;
}