//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Function to write data to file
size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    FILE *fp = (FILE *)userp;
    return fwrite(contents, size, nmemb, fp);
}

// Function to handle progress updates
int ProgressCallback(void *clientp, curl_off_t dltotal, curl_off_t dlnow, curl_off_t ultotal, curl_off_t ulnow) {
    char buffer[64];
    sprintf(buffer, "Download progress: %ld bytes downloaded out of %ld bytes total (%d%%)", dlnow, dltotal, (int)(dlnow * 100 / dltotal));
    printf("%s\r", buffer);
    return 0;
}

int main() {
    CURL *curl;
    CURLcode res;
    FILE *fp;
    char url[100];

    // Initialize curl
    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    // Set URL and file name
    strcpy(url, "http://example.com/file.txt");
    char filename[50] = "file.txt";

    // Open file for writing
    fp = fopen(filename, "wb");
    if (!fp) {
        printf("Error: Could not open file '%s' for writing.\n", filename);
        exit(1);
    }

    // Set callback functions
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, fp);

    // Set progress callback function
    curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 0L);
    curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, ProgressCallback);

    // Set URL and download file
    curl_easy_setopt(curl, CURLOPT_URL, url);
    res = curl_easy_perform(curl);

    // Check for errors
    if (res!= CURLE_OK) {
        printf("Error: Download failed with error code %d.\n", res);
    } else {
        printf("Download complete.\n");
    }

    // Close file and curl
    fclose(fp);
    curl_easy_cleanup(curl);
    curl_global_cleanup();

    return 0;
}