//Falcon2-11B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>

#define MAX_PROCESSES 10
#define PROCESS_LENGTH 20

typedef struct process {
    int process_id;
    int arrival_time;
    int burst_time;
    int cpu_time;
    int cpu_start_time;
    int cpu_end_time;
    int waiting_time;
    int turn_around_time;
    int priority;
} process;

process processes[MAX_PROCESSES];
int num_processes = 0;

void generate_processes(int num_processes) {
    srand(time(NULL));

    for (int i = 0; i < num_processes; i++) {
        processes[i].process_id = i + 1;
        processes[i].arrival_time = rand() % 1000;
        processes[i].burst_time = rand() % 1000;
        processes[i].cpu_time = 0;
        processes[i].cpu_start_time = 0;
        processes[i].cpu_end_time = 0;
        processes[i].waiting_time = 0;
        processes[i].turn_around_time = 0;
        processes[i].priority = rand() % 10;
    }
}

void print_processes() {
    for (int i = 0; i < num_processes; i++) {
        printf("Process %d: ", i + 1);
        printf("Arrival Time: %d\n", processes[i].arrival_time);
        printf("Burst Time: %d\n", processes[i].burst_time);
        printf("CPU Time: %d\n", processes[i].cpu_time);
        printf("CPU Start Time: %d\n", processes[i].cpu_start_time);
        printf("CPU End Time: %d\n", processes[i].cpu_end_time);
        printf("Waiting Time: %d\n", processes[i].waiting_time);
        printf("Turn Around Time: %d\n", processes[i].turn_around_time);
        printf("Priority: %d\n\n", processes[i].priority);
    }
}

void run_processes() {
    for (int i = 0; i < num_processes; i++) {
        processes[i].cpu_start_time = processes[i].arrival_time;
        processes[i].cpu_end_time = processes[i].cpu_start_time + processes[i].burst_time;
        processes[i].waiting_time = processes[i].cpu_start_time - processes[i].arrival_time;
        processes[i].turn_around_time = processes[i].cpu_end_time - processes[i].arrival_time;
        processes[i].cpu_time = processes[i].cpu_end_time - processes[i].cpu_start_time;
    }

    for (int i = 0; i < num_processes; i++) {
        if (processes[i].cpu_end_time == processes[i].cpu_start_time) {
            continue;
        }
        int j = 0;
        while (processes[j].cpu_end_time < processes[i].cpu_start_time) {
            j++;
        }
        while (processes[i].cpu_start_time < processes[j].cpu_end_time) {
            processes[i].cpu_time += processes[j].burst_time;
            processes[i].cpu_start_time += processes[j].burst_time;
            processes[i].cpu_end_time += processes[j].burst_time;
            processes[j].waiting_time += processes[j].burst_time;
            processes[j].turn_around_time += processes[j].burst_time;
            processes[i].waiting_time += processes[j].burst_time;
            processes[i].turn_around_time += processes[j].burst_time;
            j++;
        }
    }
}

void print_results() {
    for (int i = 0; i < num_processes; i++) {
        printf("Process %d: ", i + 1);
        printf("CPU Time: %d\n", processes[i].cpu_time);
        printf("Waiting Time: %d\n", processes[i].waiting_time);
        printf("Turn Around Time: %d\n", processes[i].turn_around_time);
        printf("Priority: %d\n", processes[i].priority);
        printf("\n");
    }
}

int main() {
    generate_processes(num_processes);
    run_processes();
    print_processes();
    print_results();
    return 0;
}