//GEMINI-pro DATASET v1.0 Category: System administration ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

int main()
{
  // The great system administration adventure begins!

  // Declare our valiant knights (processes)
  pid_t pid1, pid2, pid3;

  // Spawn the first knight: Sir Process 1
  pid1 = fork();
  if (pid1 == 0) {
    // This is Sir Process 1 speaking!
    printf("I am Sir Process 1, the fearless file manager!\n");

    // Let's conquer some files!
    system("ls -l");
    exit(0);
  }

  // Spawn the second knight: Dame Process 2
  pid2 = fork();
  if (pid2 == 0) {
    // This is Dame Process 2, the wise network explorer!
    printf("I am Dame Process 2, the network navigator!\n");

    // Let's venture into the vast internet!
    system("ping www.google.com");
    exit(0);
  }

  // Spawn the third knight: Lord Process 3
  pid3 = fork();
  if (pid3 == 0) {
    // This is Lord Process 3, the mighty memory manager!
    printf("I am Lord Process 3, the memory master!\n");

    // Let's inspect some memory, shall we?
    system("free -m");
    exit(0);
  }

  // The king (main process) waits patiently for his knights
  waitpid(pid1, NULL, 0);
  waitpid(pid2, NULL, 0);
  waitpid(pid3, NULL, 0);

  // The adventure is complete!
  printf("\nAll knights have returned from their quests!\n");

  return 0;
}