//Gemma-7B DATASET v1.0 Category: Maze Route Finder ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>

#define MAX 10

int main() {
    int x, y, i, j, maze[MAX][MAX], route[MAX][MAX], distance[MAX][MAX];
    int dx[] = {0, 1, 0, -1};
    int dy[] = {1, 0, -1, 0};

    // Initialize the maze
    for (i = 0; i < MAX; i++) {
        for (j = 0; j < MAX; j++) {
            maze[i][j] = 0;
            route[i][j] = -1;
            distance[i][j] = MAX;
        }
    }

    // Create the maze
    maze[3][3] = 1;
    maze[4][3] = 1;
    maze[5][3] = 1;
    maze[4][4] = 1;
    maze[5][4] = 1;
    maze[4][5] = 1;
    maze[5][5] = 1;

    // Find the route
    distance[0][0] = 0;
    route[0][0] = 0;
    for (i = 0; i < MAX; i++) {
        for (j = 0; j < MAX; j++) {
            if (distance[i][j] != MAX) {
                for (int k = 0; k < 4; k++) {
                    int nx = i + dx[k];
                    int ny = j + dy[k];
                    if (nx >= 0 && ny >= 0 && nx < MAX && ny < MAX && maze[nx][ny] == 0 && distance[nx][ny] > distance[i][j] + 1) {
                        distance[nx][ny] = distance[i][j] + 1;
                        route[nx][ny] = route[i][j] + 1;
                    }
                }
            }
        }
    }

    // Print the route
    printf("The route is:\n");
    for (i = 0; i < MAX; i++) {
        for (j = 0; j < MAX; j++) {
            printf("%d ", route[i][j]);
        }
        printf("\n");
    }

    return 0;
}