//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5

typedef struct Process {
    int process_id;
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

void calculate_waiting_time(Process *processes, int num_processes) {
    for (int i = 0; i < num_processes; i++) {
        processes[i].waiting_time = 0;
        for (int j = 0; j < i; j++) {
            processes[i].waiting_time += processes[j].burst_time;
        }
    }
}

void calculate_turnaround_time(Process *processes, int num_processes) {
    for (int i = 0; i < num_processes; i++) {
        processes[i].turnaround_time = processes[i].burst_time + processes[i].waiting_time;
    }
}

int main() {
    Process processes[MAX_PROCESSES];

    // Create processes
    processes[0].process_id = 1;
    processes[0].burst_time = 5;

    processes[1].process_id = 2;
    processes[1].burst_time = 8;

    processes[2].process_id = 3;
    processes[2].burst_time = 3;

    processes[3].process_id = 4;
    processes[3].burst_time = 4;

    processes[4].process_id = 5;
    processes[4].burst_time = 2;

    // Calculate waiting time
    calculate_waiting_time(processes, MAX_PROCESSES);

    // Calculate turnaround time
    calculate_turnaround_time(processes, MAX_PROCESSES);

    // Print results
    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("Process ID: %d, Burst Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].burst_time, processes[i].waiting_time, processes[i].turnaround_time);
    }

    return 0;
}