//Falcon2-11B DATASET v1.0 Category: Table Game ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>

typedef struct Card {
    char suit;
    char rank;
} Card;

typedef struct Player {
    int score;
    Card hand[2];
} Player;

void display_player(Player player) {
    printf("Score: %d\n", player.score);
    printf("Hand: %c %c\n", player.hand[0].rank, player.hand[1].rank);
}

void deal_card(Card* card, char suit) {
    if (card == NULL) {
        printf("Error: Card pointer is NULL.\n");
        return;
    }

    card->suit = suit;
    switch (card->suit) {
        case 'S':
            card->rank = (rand() % 13) + 'A';
            break;
        case 'C':
            card->rank = (rand() % 13) + 'A';
            break;
        case 'H':
            card->rank = (rand() % 13) + 'A';
            break;
        case 'D':
            card->rank = (rand() % 13) + 'A';
            break;
    }
}

void play_blackjack() {
    srand(time(NULL));

    Player player1;
    Player player2;

    printf("Player 1: Deal Card\n");
    deal_card(player1.hand, 'S');
    deal_card(player1.hand, 'H');
    display_player(player1);

    printf("Player 2: Deal Card\n");
    deal_card(player2.hand, 'S');
    deal_card(player2.hand, 'H');
    display_player(player2);

    if (player1.score == 21) {
        printf("Player 1 wins!\n");
    } else if (player2.score == 21) {
        printf("Player 2 wins!\n");
    } else if (player1.score > 21 || player2.score > 21) {
        printf("Player 1 loses!\n");
    } else if (player1.score > player2.score) {
        printf("Player 1 wins!\n");
    } else {
        printf("Player 2 wins!\n");
    }
}

int main() {
    play_blackjack();
    return 0;
}