//LLAMA2-13B DATASET v1.0 Category: Phone Book ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the phone book structure
typedef struct {
    char name[50];    // Name of the person
    char number[20];  // Phone number of the person
} phone_book;

// Function to add a new person to the phone book
void add_person(phone_book *book, char *name, char *number) {
    printf("Hello there! Welcome to our cheerful phone book!\n");
    if (strlen(name) > 50) {
        printf("Whoa, that's a long name! Let's keep it short and sweet, shall we?\n");
    } else if (strlen(number) > 20) {
        printf("Oh no, that's a long phone number! Better keep it short and sweet too!\n");
    } else {
        strcpy(book->name, name);
        strcpy(book->number, number);
        printf("Yay! You've been added to our phone book! 😊\n");
    }
}

// Function to search for a person in the phone book
int search_person(phone_book *book, char *name) {
    int i;
    for (i = 0; i < 10; i++) {
        if (strcmp(book->name, name) == 0) {
            printf("Found it! Here's the phone number of %s: %s\n", name, book->number);
            return 1;
        }
        book++;
    }
    return 0;
}

int main() {
    phone_book book[10];
    char name[50];
    char number[20];

    // Add some people to the phone book
    add_person(&book[0], "Alice", "555-1234");
    add_person(&book[1], "Bob", "555-5678");
    add_person(&book[2], "Charlie", "555-9012");

    // Search for a person in the phone book
    if (search_person(&book[0], "Alice")) {
        printf("Found Alice's number: %s\n", book[0].number);
    } else {
        printf("Alice not found 😔\n");
    }

    return 0;
}