//Code Llama-13B DATASET v1.0 Category: Banking Record System ; Style: rigorous
/*
 * Banking Record System
 * A rigorous example program in C
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to represent a bank account
struct account {
    int id;
    char name[50];
    int balance;
    int account_number;
};

// Function to add a new account
void add_account(struct account *acc, int id, char *name, int balance, int account_number) {
    acc->id = id;
    strcpy(acc->name, name);
    acc->balance = balance;
    acc->account_number = account_number;
}

// Function to deposit money into an account
void deposit(struct account *acc, int amount) {
    acc->balance += amount;
}

// Function to withdraw money from an account
void withdraw(struct account *acc, int amount) {
    if (acc->balance < amount) {
        printf("Insufficient funds!\n");
    } else {
        acc->balance -= amount;
    }
}

// Function to display the balance of an account
void display_balance(struct account *acc) {
    printf("Balance: %d\n", acc->balance);
}

int main() {
    // Create an array of 1000 accounts
    struct account accounts[1000];

    // Add some accounts
    add_account(&accounts[0], 1, "John", 1000, 123456);
    add_account(&accounts[1], 2, "Jane", 2000, 234567);
    add_account(&accounts[2], 3, "Bob", 3000, 345678);

    // Deposit some money into an account
    deposit(&accounts[1], 500);

    // Withdraw some money from an account
    withdraw(&accounts[2], 200);

    // Display the balance of an account
    display_balance(&accounts[1]);

    return 0;
}