//GPT-4o-mini DATASET v1.0 Category: Classical Circuit Simulator ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_COMPONENTS 100

typedef struct {
    char type; // 'R' for Resistor, 'C' for Capacitor, 'L' for Inductor
    double value; // in Ohms for resistors, Farads for capacitors, Henrys for inductors
} Component;

typedef struct {
    Component components[MAX_COMPONENTS];
    int count;
} Circuit;

Circuit createCircuit() {
    Circuit circuit;
    circuit.count = 0;
    return circuit;
}

void addComponent(Circuit* circuit, char type, double value) {
    if (circuit->count < MAX_COMPONENTS) {
        circuit->components[circuit->count].type = type;
        circuit->components[circuit->count].value = value;
        circuit->count++;
    } else {
        printf("Cannot add more components, circuit is full!\n");
    }
}

double computeTotalResistance(Circuit* circuit) {
    double totalResistance = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->components[i].type == 'R') {
            totalResistance += circuit->components[i].value;
        }
    }
    return totalResistance;
}

double computeEquivalentCapacitance(Circuit* circuit) {
    double totalCapacitance = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->components[i].type == 'C') {
            totalCapacitance += circuit->components[i].value;
        }
    }
    return totalCapacitance;
}

double computeEquivalentInductance(Circuit* circuit) {
    double totalInductance = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->components[i].type == 'L') {
            totalInductance += circuit->components[i].value;
        }
    }
    return totalInductance;
}

void printCircuit(Circuit* circuit) {
    printf("Circuit Components:\n");
    for (int i = 0; i < circuit->count; i++) {
        printf("Component %d: Type = %c, Value = %.2f\n", i + 1,
               circuit->components[i].type,
               circuit->components[i].value);
    }
}

void simulateCircuit(Circuit* circuit) {
    double totalResistance = computeTotalResistance(circuit);
    double totalCapacitance = computeEquivalentCapacitance(circuit);
    double totalInductance = computeEquivalentInductance(circuit);

    printf("\n--- Circuit Simulation Results ---\n");
    printf("Total Resistance: %.2f Ohms\n", totalResistance);
    printf("Equivalent Capacitance: %.5f F\n", totalCapacitance);
    printf("Equivalent Inductance: %.5f H\n", totalInductance);
}

int main() {
    Circuit myCircuit = createCircuit();

    addComponent(&myCircuit, 'R', 100.0); // 100 Ohm resistor
    addComponent(&myCircuit, 'C', 0.001); // 1000 uF capacitor
    addComponent(&myCircuit, 'L', 0.01);  // 10 mH inductor
    addComponent(&myCircuit, 'R', 200.0); // 200 Ohm resistor
    addComponent(&myCircuit, 'C', 0.002); // 2000 uF capacitor

    printCircuit(&myCircuit);
    simulateCircuit(&myCircuit);

    return 0;
}