//MISTRAL-7B DATASET v1.0 Category: System event logger ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Event structure
typedef struct {
    char description[100];
    time_t timestamp;
    struct Event* next;
} Event;

// Global event head pointer
Event* globalEventHead = NULL;

// Function prototypes
void logEvent(char* description);
void displayLog();
void clearLog();

int main(int argc, char* argv[]) {
    srand(time(NULL));

    // Example event logging
    logEvent("Event 1: Button Pressed");
    logEvent("Event 2: Temperature Alert");

    // Display and clear the log
    displayLog();
    clearLog();

    return 0;
}

// Log an event with a given description
void logEvent(char* description) {
    // Allocate memory for new event
    Event* newEvent = (Event*) malloc(sizeof(Event));

    if (newEvent == NULL) {
        printf("Error: Out of memory!\n");
        return;
    }

    // Set event description and current timestamp
    strcpy(newEvent->description, description);
    newEvent->timestamp = time(NULL);

    // Set next event pointer to current event head
    newEvent->next = globalEventHead;

    // Update global event head pointer
    globalEventHead = newEvent;
}

// Display all events in the log
void displayLog() {
    printf("\nEvent Log:\n");

    Event* currentEvent = globalEventHead;

    while (currentEvent != NULL) {
        printf("%s (%ld)\n", currentEvent->description, currentEvent->timestamp);
        currentEvent = currentEvent->next;
    }
}

// Clear the event log
void clearLog() {
    Event* currentEvent = globalEventHead;
    Event* nextEvent;

    while (currentEvent != NULL) {
        nextEvent = currentEvent->next;
        free(currentEvent);
        currentEvent = nextEvent;
    }

    globalEventHead = NULL;
}