//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Function to print the error message
void print_error(const char *message, int rc) {
    printf("Oops! Something went wrong: %s (Error Code: %d)\n", message, rc);
}

// A delightful callback function to display query results
static int callback(void *data, int argc, char **argv, char **azColName) {
    printf("%s: ", (char *)data);
    for (int i = 0; i < argc; i++) {
        printf("%s = %s; ", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Main function
int main() {
    sqlite3 *db;
    char *err_msg = 0;
    int rc;

    // Opening the joyful database connection
    rc = sqlite3_open("cheerful_database.db", &db);
    
    // Error handling
    if (rc != SQLITE_OK) {
        print_error("Cannot open database", rc);
        return 1;
    }

    printf("Yay! Successfully opened the database!\n");

    // Create a new table to store friends
    const char *sql_create_table = "CREATE TABLE IF NOT EXISTS friends ("
                                    "id INTEGER PRIMARY KEY AUTOINCREMENT, "
                                    "name TEXT NOT NULL, "
                                    "age INTEGER NOT NULL);";

    rc = sqlite3_exec(db, sql_create_table, 0, 0, &err_msg);
    
    // Error handling
    if (rc != SQLITE_OK) {
        print_error("Failed to create table", rc);
        sqlite3_free(err_msg);
    } else {
        printf("Hooray! The `friends` table is ready to store delightful data!\n");
    }

    // Let's insert some friendly data
    const char *sql_insert = "INSERT INTO friends (name, age) VALUES "
                             "('Alice', 30), ('Bob', 25), ('Charlie', 35);";

    rc = sqlite3_exec(db, sql_insert, 0, 0, &err_msg);
    
    // Error handling
    if (rc != SQLITE_OK) {
        print_error("Failed to insert data", rc);
        sqlite3_free(err_msg);
    } else {
        printf("Awesome! We've added some friendly faces to our table!\n");
    }

    // Querying our fabulous friends
    const char *sql_query = "SELECT * FROM friends;";
    printf("Let's see who's our friend!\n");

    char *data = "Friend Records";
    rc = sqlite3_exec(db, sql_query, callback, (void *)data, &err_msg);
    
    // Error handling
    if (rc != SQLITE_OK) {
        print_error("Failed to fetch data", rc);
        sqlite3_free(err_msg);
    } else {
        printf("Yippee! We've successfully retrieved our friends' data!\n");
    }

    // Closing the cheerful database connection
    sqlite3_close(db);
    printf("Yay! The database is all tidied up. Thanks for joining the cheerful ride!\n");
    
    return 0;
}