//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: standalone
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[50];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item limit exceeded.\n");
}

int calculateTotal(int items_count) {
    int total = 0;
    for (int i = 0; i < items_count; i++) {
        total += items[i].quantity * items[i].price;
    }

    return total;
}

void generateBill(int items_count) {
    printf("--------------------------------------------------------\n");
    printf("C Cafe Billing System\n");
    printf("--------------------------------------------------------\n");

    for (int i = 0; i < items_count; i++) {
        printf("%s - %d @ %.2f\n", items[i].name, items[i].quantity, items[i].price);
    }

    printf("\nTotal: %.2f\n", calculateTotal(items_count));
    printf("--------------------------------------------------------\n");
}

int main() {
    addItem("Coffee", 5, 2.50);
    addItem("Tea", 3, 1.80);
    addItem("Juice", 2, 1.20);

    generateBill(3);

    return 0;
}