//Falcon-180B DATASET v1.0 Category: Medical Store Management System ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEM_NAME_LEN 50
#define MAX_ITEM_QUANTITY 100
#define MAX_ITEM_PRICE 999.99

typedef struct {
    char name[MAX_ITEM_NAME_LEN];
    int quantity;
    float price;
} item;

typedef struct {
    item items[MAX_ITEM_QUANTITY];
    int num_items;
} store;

void initialize_store(store* s) {
    s->num_items = 0;
}

void add_item(store* s, item i) {
    if (s->num_items >= MAX_ITEM_QUANTITY) {
        printf("Store is full. Cannot add item.\n");
        return;
    }

    s->items[s->num_items++] = i;
}

void remove_item(store* s, int index) {
    if (index >= s->num_items || index < 0) {
        printf("Invalid index.\n");
        return;
    }

    for (int i = index; i < s->num_items - 1; i++) {
        s->items[i] = s->items[i + 1];
    }

    s->num_items--;
}

void display_items(store* s) {
    printf("Store Contents:\n");
    for (int i = 0; i < s->num_items; i++) {
        printf("%d. %s - %d units - $%.2f\n", i + 1, s->items[i].name, s->items[i].quantity, s->items[i].price);
    }
}

void main() {
    store my_store;
    initialize_store(&my_store);

    add_item(&my_store, (item){.name = "Aspirin",.quantity = 50,.price = 5.99 });
    add_item(&my_store, (item){.name = "Ibuprofen",.quantity = 100,.price = 8.99 });
    add_item(&my_store, (item){.name = "Acetaminophen",.quantity = 75,.price = 6.49 });

    display_items(&my_store);

    remove_item(&my_store, 1);

    display_items(&my_store);
}