//Falcon2-11B DATASET v1.0 Category: Memory Game ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>

#define NUM_CARDS 12

typedef struct card {
    int value;
    int hidden;
} Card;

Card cards[NUM_CARDS];
int openCards[NUM_CARDS];
int turn;

void displayCards(int n) {
    for (int i = 0; i < n; i++) {
        printf("Card %d: %d\n", i + 1, cards[i].value);
    }
}

void hideCard(int index) {
    cards[index].hidden = 1;
}

void revealCard(int index) {
    if (cards[index].hidden == 1) {
        cards[index].hidden = 0;
        openCards[turn] = cards[index].value;
        printf("Card revealed: %d\n", cards[index].value);
    } else {
        printf("This card has already been revealed!\n");
    }
}

void shuffleCards() {
    for (int i = 0; i < NUM_CARDS - 1; i++) {
        int j = rand() % (NUM_CARDS - i);
        Card temp = cards[i];
        cards[i] = cards[j];
        cards[j] = temp;
    }
}

int main() {
    for (int i = 0; i < NUM_CARDS; i++) {
        cards[i].value = i + 1;
        cards[i].hidden = 0;
    }

    shuffleCards();
    displayCards(NUM_CARDS);

    for (int i = 0; i < NUM_CARDS; i++) {
        printf("Turn %d: Reveal card ", ++turn);
        revealCard(i);
        displayCards(NUM_CARDS);
    }

    printf("\nGame over!\n");
    return 0;
}