//GPT-4o-mini DATASET v1.0 Category: Building a JSON Parser ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// Define a structure to hold a JSON value
typedef struct JsonValue {
    char *key;
    char *value;
    struct JsonValue *next;
} JsonValue;

// Function to create a new JSON value
JsonValue* createJsonValue(const char *key, const char *value) {
    JsonValue *newValue = (JsonValue *)malloc(sizeof(JsonValue));
    newValue->key = strdup(key);
    newValue->value = strdup(value);
    newValue->next = NULL;
    return newValue;
}

// Function to free a JSON value
void freeJsonValue(JsonValue *val) {
    if (val) {
        free(val->key);
        free(val->value);
        free(val);
    }
}

// Function to parse JSON string
JsonValue* parseJson(const char *json) {
    JsonValue *head = NULL, *tail = NULL;
    const char *p = json;

    while (*p) {
        // Skip whitespace
        while (isspace(*p)) p++;

        // Process key
        if (*p != '"') {
            fprintf(stderr, "Error: Expected '\"' at start of key\n");
            return NULL;
        }
        p++; // skip opening quote
        const char *keyStart = p;
        while (*p && *p != '"') p++;
        if (*p != '"') {
            fprintf(stderr, "Error: Expected '\"' at end of key\n");
            return NULL;
        }
        char *key = strndup(keyStart, p - keyStart);
        p++; // skip closing quote

        // Skip whitespace and expect a colon
        while (isspace(*p)) p++;
        if (*p != ':') {
            fprintf(stderr, "Error: Expected ':' after key\n");
            free(key);
            return NULL;
        }
        p++; // skip colon

        // Skip whitespace
        while (isspace(*p)) p++;

        // Process value
        if (*p != '"') {
            fprintf(stderr, "Error: Expected '\"' at start of value\n");
            free(key);
            return NULL;
        }
        p++; // skip opening quote
        const char *valueStart = p;
        while (*p && *p != '"') p++;
        if (*p != '"') {
            fprintf(stderr, "Error: Expected '\"' at end of value\n");
            free(key);
            return NULL;
        }
        char *value = strndup(valueStart, p - valueStart);
        p++; // skip closing quote

        // Create and link the new JsonValue
        JsonValue *newValue = createJsonValue(key, value);
        free(key);
        free(value);
        if (!head) {
            head = newValue;
            tail = newValue;
        } else {
            tail->next = newValue;
            tail = newValue;
        }

        // Continue parsing
        while (isspace(*p)) p++;
        if (*p == ',') {
            p++; // skip comma
        } else if (*p == '}') {
            break; // end of JSON object
        } else {
            fprintf(stderr, "Error: Expected ',' or '}'\n");
            return NULL;
        }
    }

    return head;
}

// Function to print parsed JSON values
void printJsonValues(JsonValue *head) {
    JsonValue *current = head;
    while (current) {
        printf("Key: %s, Value: %s\n", current->key, current->value);
        current = current->next;
    }
}

// Function to free the parsed JSON values
void freeJsonValues(JsonValue *head) {
    JsonValue *current = head;
    while (current) {
        JsonValue *next = current->next;
        freeJsonValue(current);
        current = next;
    }
}

int main() {
    const char *json = "{\"name\": \"John\", \"age\": \"30\", \"city\": \"New York\"}";

    JsonValue *parsedJson = parseJson(json);
    if (parsedJson) {
        printJsonValues(parsedJson);
        freeJsonValues(parsedJson);
    } else {
        fprintf(stderr, "Failed to parse JSON\n");
    }

    return 0;
}