//Falcon2-11B DATASET v1.0 Category: Public-Key Algorithm Implementation ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define KEY_SIZE 256

typedef struct {
    unsigned char key[KEY_SIZE];
    unsigned char plaintext[KEY_SIZE];
} KeyPair;

KeyPair generateKeyPair() {
    KeyPair keyPair;
    unsigned char randomSeed[KEY_SIZE];
    unsigned char key[KEY_SIZE];
    unsigned char plaintext[KEY_SIZE];

    // Generate random seed
    srand(time(NULL));
    for (int i = 0; i < KEY_SIZE; i++) {
        randomSeed[i] = rand();
    }

    // Generate key
    for (int i = 0; i < KEY_SIZE; i++) {
        key[i] = randomSeed[i] % KEY_SIZE;
    }

    // Generate plaintext
    for (int i = 0; i < KEY_SIZE; i++) {
        plaintext[i] = randomSeed[i] % KEY_SIZE;
    }

    // Initialize keyPair struct
    memcpy(keyPair.key, key, KEY_SIZE);
    memcpy(keyPair.plaintext, plaintext, KEY_SIZE);

    return keyPair;
}

int main() {
    KeyPair keyPair = generateKeyPair();

    // Print key
    printf("Key: ");
    for (int i = 0; i < KEY_SIZE; i++) {
        printf("%02x", keyPair.key[i]);
    }
    printf("\n");

    // Print plaintext
    printf("Plaintext: ");
    for (int i = 0; i < KEY_SIZE; i++) {
        printf("%02x", keyPair.plaintext[i]);
    }
    printf("\n");

    return 0;
}