//Falcon-180B DATASET v1.0 Category: Digital Auction System ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_ITEMS 100
#define MAX_USERS 50
#define MAX_BIDS 1000

typedef struct {
    int id;
    char name[50];
    int balance;
} User;

typedef struct {
    int id;
    char name[100];
    int min_bid;
    int current_bid;
    User* owner;
} Item;

User users[MAX_USERS];
Item items[MAX_ITEMS];
int num_users = 0;
int num_items = 0;

void register_user(char* name) {
    int id = num_users++;
    users[id].id = id;
    strcpy(users[id].name, name);
    users[id].balance = 1000;
}

void add_item(char* name, int min_bid, User* owner) {
    int id = num_items++;
    items[id].id = id;
    strcpy(items[id].name, name);
    items[id].min_bid = min_bid;
    items[id].current_bid = min_bid;
    items[id].owner = owner;
}

void place_bid(int item_id, int bid_amount, User* bidder) {
    if (bid_amount < items[item_id].current_bid) {
        printf("Bid amount is too low.\n");
        return;
    }
    if (bid_amount == items[item_id].current_bid) {
        printf("You have already placed a bid for this item.\n");
        return;
    }
    if (bid_amount > bidder->balance) {
        printf("You do not have enough balance to place this bid.\n");
        return;
    }
    items[item_id].current_bid = bid_amount;
    items[item_id].owner = bidder;
    bidder->balance -= bid_amount;
    printf("Bid placed successfully.\n");
}

void start_auction(int item_id) {
    int bid_amount = items[item_id].min_bid;
    while (1) {
        sleep(1);
        if (bid_amount >= items[item_id].current_bid) {
            printf("Item sold to %s for $%d.\n", items[item_id].owner->name, items[item_id].current_bid);
            break;
        }
        bid_amount += 10;
        items[item_id].current_bid = bid_amount;
    }
}

int main() {
    srand(time(NULL));
    register_user("John");
    register_user("Jane");
    add_item("Laptop", 500, &users[0]);
    add_item("Phone", 200, &users[1]);
    start_auction(0);
    return 0;
}