//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENSORS 10
#define MAX_SENSOR_NAME_LENGTH 20

typedef struct {
    char name[MAX_SENSOR_NAME_LENGTH];
    float temperature;
    float threshold;
} Sensor;

Sensor sensors[MAX_SENSORS];
int numSensors;

void addSensor(char *name, float threshold) {
    if (numSensors >= MAX_SENSORS) {
        printf("Error: Maximum number of sensors reached.\n");
        return;
    }

    strcpy(sensors[numSensors].name, name);
    sensors[numSensors].temperature = 0;
    sensors[numSensors].threshold = threshold;

    numSensors++;
}

void updateSensorTemperature(int index, float temperature) {
    if (index >= numSensors) {
        printf("Error: Sensor index out of range.\n");
        return;
    }

    sensors[index].temperature = temperature;
}

void printSensors() {
    printf("Sensors:\n");
    for (int i = 0; i < numSensors; i++) {
        printf("%s: %.2f°C\n", sensors[i].name, sensors[i].temperature);
    }
}

void checkSensors() {
    for (int i = 0; i < numSensors; i++) {
        if (sensors[i].temperature >= sensors[i].threshold) {
            printf("Warning: %s temperature exceeded threshold of %.2f°C.\n", sensors[i].name, sensors[i].threshold);
        }
    }
}

int main() {
    addSensor("CPU", 60);
    addSensor("GPU", 70);

    updateSensorTemperature(0, 50);
    updateSensorTemperature(1, 65);

    printSensors();
    checkSensors();

    return 0;
}