//Gemma-7B DATASET v1.0 Category: Medical Store Management System ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct item {
    char name[20];
    int quantity;
    double price;
} item_t;

item_t items[MAX_ITEMS];

void init_items() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        items[i].name[0] = '\0';
        items[i].quantity = 0;
        items[i].price = 0.0;
    }
}

void add_item(char *name, int quantity, double price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item limit exceeded.\n");
}

void check_item(char *name) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            printf("Name: %s\n", items[i].name);
            printf("Quantity: %d\n", items[i].quantity);
            printf("Price: %.2lf\n", items[i].price);
            return;
        }
    }

    printf("Error: Item not found.\n");
}

int main() {
    init_items();

    add_item("Paracetamol", 20, 2.0);
    add_item("Ibuprofen", 10, 3.0);
    add_item("Nurofen", 15, 2.5);

    check_item("Ibuprofen");

    return 0;
}