//GEMINI-pro DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the possible outcomes of an alien invasion
enum alien_invasion_outcome {
  ALIENS_INVADE_AND_DESTROY_EARTH,
  ALIENS_INVADE_BUT_ARE_DEFEATED,
  ALIENS_VISIT_IN_PEACE,
  ALIENS_NEVER_VISIT_EARTH
};

// Define the probability of each outcome
double alien_invasion_probabilities[] = {
  0.001, // ALIENS_INVADE_AND_DESTROY_EARTH
  0.01,  // ALIENS_INVADE_BUT_ARE_DEFEATED
  0.05,  // ALIENS_VISIT_IN_PEACE
  0.939 // ALIENS_NEVER_VISIT_EARTH
};

// Get a random number between 0 and 1
double get_random_number() {
  return (double)rand() / RAND_MAX;
}

// Calculate the probability of an alien invasion
enum alien_invasion_outcome calculate_alien_invasion_probability() {
  double random_number = get_random_number();

  if (random_number < alien_invasion_probabilities[ALIENS_INVADE_AND_DESTROY_EARTH]) {
    return ALIENS_INVADE_AND_DESTROY_EARTH;
  } else if (random_number < alien_invasion_probabilities[ALIENS_INVADE_BUT_ARE_DEFEATED]) {
    return ALIENS_INVADE_BUT_ARE_DEFEATED;
  } else if (random_number < alien_invasion_probabilities[ALIENS_VISIT_IN_PEACE]) {
    return ALIENS_VISIT_IN_PEACE;
  } else {
    return ALIENS_NEVER_VISIT_EARTH;
  }
}

// Print the result of the alien invasion probability calculation
void print_alien_invasion_probability(enum alien_invasion_outcome outcome) {
  switch (outcome) {
    case ALIENS_INVADE_AND_DESTROY_EARTH:
      printf("The aliens have invaded and destroyed Earth. RIP.\n");
      break;
    case ALIENS_INVADE_BUT_ARE_DEFEATED:
      printf("The aliens invaded, but we kicked their butts! USA! USA! USA!\n");
      break;
    case ALIENS_VISIT_IN_PEACE:
      printf("The aliens visited in peace. They were pretty cool, actually.\n");
      break;
    case ALIENS_NEVER_VISIT_EARTH:
      printf("The aliens never visited Earth. Maybe they're just too busy playing video games.\n");
      break;
  }
}

int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Calculate the probability of an alien invasion
  enum alien_invasion_outcome outcome = calculate_alien_invasion_probability();

  // Print the result of the alien invasion probability calculation
  print_alien_invasion_probability(outcome);

  return 0;
}