//GEMINI-pro DATASET v1.0 Category: Audio processing ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <portaudio.h>
#include <math.h>

#define SAMPLE_RATE 44100
#define FRAMES_PER_BUFFER 1024
#define NUM_CHANNELS 2

void process(float *in, float *out, int numFrames) {
  for (int i = 0; i < numFrames; i++) {
    out[i * NUM_CHANNELS] = in[i * NUM_CHANNELS] * 0.5;  // Left channel
    out[i * NUM_CHANNELS + 1] = in[i * NUM_CHANNELS + 1] * 0.5;  // Right channel
  }
}

int main(int argc, char *argv[]) {
  PaStream *stream;
  PaError err;

  printf("Initializing PortAudio...\n");
  err = Pa_Initialize();
  if (err != paNoError) {
    printf("PortAudio error: %s\n", Pa_GetErrorText(err));
    return -1;
  }

  printf("Opening audio stream...\n");
  err = Pa_OpenStream(&stream, Pa_GetDefaultInputDevice(), NUM_CHANNELS, paFloat32, SAMPLE_RATE,
                      FRAMES_PER_BUFFER, process, NULL);
  if (err != paNoError) {
    printf("PortAudio error: %s\n", Pa_GetErrorText(err));
    Pa_Terminate();
    return -1;
  }

  printf("Starting audio stream...\n");
  err = Pa_StartStream(stream);
  if (err != paNoError) {
    printf("PortAudio error: %s\n", Pa_GetErrorText(err));
    Pa_CloseStream(stream);
    Pa_Terminate();
    return -1;
  }

  printf("Press any key to stop the stream...\n");
  getchar();

  printf("Stopping audio stream...\n");
  err = Pa_StopStream(stream);
  if (err != paNoError) {
    printf("PortAudio error: %s\n", Pa_GetErrorText(err));
    Pa_CloseStream(stream);
    Pa_Terminate();
    return -1;
  }

  printf("Closing audio stream...\n");
  err = Pa_CloseStream(stream);
  if (err != paNoError) {
    printf("PortAudio error: %s\n", Pa_GetErrorText(err));
    Pa_Terminate();
    return -1;
  }

  printf("Terminating PortAudio...\n");
  Pa_Terminate();

  return 0;
}