//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: surprised
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100

// Function to find the maximum value in an array
int findMax(int arr[], int size) {
    int max = arr[0];
    for (int i = 1; i < size; i++) {
        if (arr[i] > max) {
            max = arr[i];
        }
    }
    return max;
}

// Function to find the minimum value in an array
int findMin(int arr[], int size) {
    int min = arr[0];
    for (int i = 1; i < size; i++) {
        if (arr[i] < min) {
            min = arr[i];
        }
    }
    return min;
}

// Function to find the difference between the maximum and minimum values in an array
int findDiff(int arr[], int size) {
    int max = findMax(arr, size);
    int min = findMin(arr, size);
    return max - min;
}

// Function to find the maximum profit
int findMaxProfit(int arr[], int size, int k) {
    int maxProfit = 0;
    int i = 0;
    int j = k - 1;
    while (j < size) {
        int profit = findDiff(arr, j - i + 1);
        if (profit > maxProfit) {
            maxProfit = profit;
        }
        j++;
    }
    return maxProfit;
}

int main() {
    int arr[] = {2, 1, 5, 7, 3, 6, 4};
    int size = sizeof(arr) / sizeof(arr[0]);
    int k = 3;
    int maxProfit = findMaxProfit(arr, size, k);
    printf("The maximum profit is %d\n", maxProfit);
    return 0;
}