//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of characters in a name
#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    int age;
} Person;

// Function to compare two people based on their names
int compare_people(const void *a, const void *b) {
    const Person *person1 = a;
    const Person *person2 = b;
    
    return strcmp(person1->name, person2->name);
}

// Function to print a person's information
void print_person(const Person *person) {
    printf("Name: %s\n", person->name);
    printf("Age: %d\n", person->age);
}

int main() {
    // Initialize an array of people
    Person people[] = {
        {"Sir Lancelot", 35},
        {"King Arthur", 50},
        {"Queen Guinevere", 30},
        {"Merlin", 100},
        {"Sir Galahad", 25},
        {"Sir Percival", 28},
        {"Lady Morgana", 32},
        {"Sir Gawain", 40},
        {"Sir Bedevere", 45},
        {"Sir Robin", 20}
    };
    
    // Initialize the number of people
    int num_people = sizeof(people) / sizeof(Person);
    
    // Sort the array of people by name
    qsort(people, num_people, sizeof(Person), compare_people);
    
    // Print the sorted list of people
    printf("Sorted by name:\n");
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }
    
    // Sort the array of people by age
    qsort(people, num_people, sizeof(Person), compare_people);
    
    // Print the sorted list of people
    printf("\nSorted by age:\n");
    for (int i = 0; i < num_people; i++) {
        print_person(&people[i]);
    }
    
    return 0;
}