//Code Llama-13B DATASET v1.0 Category: Bucket Sort Implementation ; Style: systematic
// Bucket sort implementation in C
#include <stdio.h>
#include <stdlib.h>

void bucketSort(int arr[], int n) {
    int i, j;
    int m = 10;
    int count[m];
    int output[n];

    // initialize the count array with 0
    for (i = 0; i < m; i++) {
        count[i] = 0;
    }

    // count the number of elements in each bucket
    for (i = 0; i < n; i++) {
        count[arr[i]]++;
    }

    // calculate the starting index of each bucket
    for (i = 1; i < m; i++) {
        count[i] += count[i - 1];
    }

    // sort the elements in each bucket
    for (i = n - 1; i >= 0; i--) {
        output[count[arr[i]] - 1] = arr[i];
        count[arr[i]]--;
    }

    // copy the sorted elements to the original array
    for (i = 0; i < n; i++) {
        arr[i] = output[i];
    }
}

int main() {
    int arr[] = {3, 1, 2, 4, 5, 6, 7};
    int n = sizeof(arr) / sizeof(arr[0]);

    bucketSort(arr, n);

    printf("Sorted array is: ");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }

    return 0;
}