//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: standalone
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#define MAX_PASSWORD_LENGTH 32

int check_password_strength(char* password);

int main() {
    char password[MAX_PASSWORD_LENGTH];

    printf("Enter password: ");
    fgets(password, MAX_PASSWORD_LENGTH, stdin);

    int password_strength = check_password_strength(password);

    switch(password_strength) {
        case 1:
            printf("Weak\n");
            break;
        case 2:
            printf("Moderate\n");
            break;
        case 3:
            printf("Strong\n");
            break;
        case 4:
            printf("Very strong\n");
            break;
        default:
            printf("Invalid\n");
            break;
    }

    return 0;
}

int check_password_strength(char* password) {
    int length = strlen(password);
    int has_uppercase = 0;
    int has_lowercase = 0;
    int has_number = 0;
    int has_special_character = 0;

    for(int i = 0; i < length; i++) {
        if(isupper(password[i])) {
            has_uppercase = 1;
        } else if(islower(password[i])) {
            has_lowercase = 1;
        } else if(isdigit(password[i])) {
            has_number = 1;
        } else if(!isalnum(password[i])) {
            has_special_character = 1;
        }
    }

    int score = 0;
    score += has_uppercase * 2;
    score += has_lowercase * 2;
    score += has_number * 2;
    score += has_special_character * 2;

    if(length >= 8 && score >= 12) {
        return 4;
    } else if(length >= 8 && score >= 8) {
        return 3;
    } else if(length >= 6 && score >= 6) {
        return 2;
    } else {
        return 1;
    }
}