//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/mman.h>

typedef struct {
    char *name;
    int pid;
    int status;
} process_t;

void launch_process(process_t *process, char *command) {
    pid_t child_pid = fork();

    if (child_pid == 0) {
        execlp(command, command, NULL);
        exit(EXIT_FAILURE);
    } else if (child_pid < 0) {
        perror("fork");
        exit(EXIT_FAILURE);
    } else {
        process->pid = child_pid;
        process->status = 0;
    }
}

int wait_for_process(process_t *process) {
    int status;
    waitpid(process->pid, &status, WUNTRACED);

    if (WIFEXITED(status)) {
        process->status = WEXITSTATUS(status);
    } else if (WIFSIGNALED(status)) {
        process->status = WTERMSIG(status);
    }

    return process->status;
}

void cleanup_process(process_t *process) {
    if (process->status == 0) {
        kill(process->pid, SIGKILL);
        wait_for_process(process);
    }
}

int main(int argc, char **argv) {
    if (argc < 2) {
        fprintf(stderr, "Usage: %s command [arguments...]\n", argv[0]);
        return 1;
    }

    process_t process;
    launch_process(&process, argv[1]);

    int status = wait_for_process(&process);

    if (status!= 0) {
        fprintf(stderr, "Command '%s' failed with status %d\n", process.name, status);
        return status;
    }

    return 0;
}