//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: scientific
#include <stdio.h>
#include <stdlib.h>

#define MAX_NUM 100

typedef struct {
    int value;
    int index;
} Coin;

int main() {
    int numCoins[] = {1, 5, 10, 25};
    int numCoinsSize = sizeof(numCoins) / sizeof(numCoins[0]);
    int totalAmount = 63;
    Coin coins[MAX_NUM];
    int numCoinsUsed = 0;
    int i, j;

    // Initialize coins array with -1
    for (i = 0; i < MAX_NUM; i++) {
        coins[i].value = -1;
        coins[i].index = -1;
    }

    // Sort the coins in descending order
    for (i = 0; i < numCoinsSize; i++) {
        for (j = i + 1; j < numCoinsSize; j++) {
            if (numCoins[i] < numCoins[j]) {
                int temp = numCoins[i];
                numCoins[i] = numCoins[j];
                numCoins[j] = temp;
            }
        }
    }

    // Apply greedy algorithm to find the minimum number of coins
    for (i = numCoinsSize - 1; i >= 0 && totalAmount > 0; i--) {
        if (totalAmount >= numCoins[i]) {
            totalAmount -= numCoins[i];
            coins[numCoinsUsed].value = numCoins[i];
            coins[numCoinsUsed].index = i;
            numCoinsUsed++;
        }
    }

    // Print the result
    printf("Minimum number of coins: %d\n", numCoinsUsed);
    for (i = 0; i < numCoinsUsed; i++) {
        printf("Coin %d: value = %d, index = %d\n", i + 1, coins[i].value, coins[i].index);
    }

    return 0;
}