//GPT-4o-mini DATASET v1.0 Category: Digital Auction System ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    char itemName[100];
    float startingBid;
    float highestBid;
    char highestBidder[100];
    int auctionActive;
} Auction;

void createAuction(Auction *auction, const char *itemName, float startingBid) {
    strcpy(auction->itemName, itemName);
    auction->startingBid = startingBid;
    auction->highestBid = startingBid;
    strcpy(auction->highestBidder, "None");
    auction->auctionActive = 1;
    printf("Auction for '%s' created with starting bid %.2f\n", auction->itemName, auction->startingBid);
}

void placeBid(Auction *auction, const char *bidderName, float bidAmount) {
    if (!auction->auctionActive) {
        printf("Auction for '%s' is not active.\n", auction->itemName);
        return;
    }
    if (bidAmount > auction->highestBid) {
        auction->highestBid = bidAmount;
        strcpy(auction->highestBidder, bidderName);
        printf("New bid placed by %s: %.2f\n", bidderName, bidAmount);
    } else {
        printf("Bid amount must be higher than the current highest bid (%.2f)\n", auction->highestBid);
    }
}

void closeAuction(Auction *auction) {
    auction->auctionActive = 0;
    printf("Auction for '%s' is now closed. Highest bid: %.2f by %s\n", auction->itemName, auction->highestBid, auction->highestBidder);
}

void displayAuctionStatus(const Auction *auction) {
    if (auction->auctionActive) {
        printf("Auction for '%s': Highest bid is %.2f by %s\n", auction->itemName, auction->highestBid, auction->highestBidder);
    } else {
        printf("Auction for '%s' is closed. Final bid: %.2f by %s\n", auction->itemName, auction->highestBid, auction->highestBidder);
    }
}

int main() {
    Auction auction1;

    createAuction(&auction1, "Vintage Guitar", 100.00);

    displayAuctionStatus(&auction1);

    placeBid(&auction1, "Alice", 120.00);
    displayAuctionStatus(&auction1);

    placeBid(&auction1, "Bob", 115.00);
    displayAuctionStatus(&auction1);

    placeBid(&auction1, "Charlie", 150.00);
    displayAuctionStatus(&auction1);

    placeBid(&auction1, "Alice", 130.00);
    displayAuctionStatus(&auction1);

    closeAuction(&auction1);
    displayAuctionStatus(&auction1);

    // Reattempt to place a bid after auction is closed
    placeBid(&auction1, "Dan", 160.00);

    return 0;
}