//Code Llama-13B DATASET v1.0 Category: Networking ; Style: authentic
// Networking Example Program
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>

#define BUF_SIZE 1024

int main(int argc, char *argv[]) {
    int sockfd, n;
    char recvBuf[BUF_SIZE];
    struct sockaddr_in serv_addr;

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        printf("ERROR: Failed to create socket\n");
        return 1;
    }

    // Initialize server address
    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(5000);
    serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        printf("ERROR: Failed to connect to server\n");
        return 1;
    }

    // Send message to server
    char *message = "Hello, server!";
    n = write(sockfd, message, strlen(message));
    if (n < 0) {
        printf("ERROR: Failed to send message to server\n");
        return 1;
    }

    // Receive message from server
    n = read(sockfd, recvBuf, BUF_SIZE);
    if (n < 0) {
        printf("ERROR: Failed to receive message from server\n");
        return 1;
    }

    // Print received message
    printf("Received message from server: %s\n", recvBuf);

    // Close socket
    close(sockfd);

    return 0;
}