//Falcon-180B DATASET v1.0 Category: Ebook reader ; Style: introspective
#include <stdio.h>
#include <stdlib.h>

#define TRUE 1
#define FALSE 0
#define OK 1
#define ERROR 0
#define MAX_SIZE 100

typedef struct {
    char data[MAX_SIZE];
    int top;
} Stack;

void init_stack(Stack* stack) {
    stack->top = -1;
}

int is_empty(Stack* stack) {
    return (stack->top == -1);
}

int is_full(Stack* stack) {
    return (stack->top == MAX_SIZE - 1);
}

void push(Stack* stack, char element) {
    if (is_full(stack)) {
        printf("Stack Overflow\n");
        return;
    }
    stack->top++;
    stack->data[stack->top] = element;
}

char pop(Stack* stack) {
    if (is_empty(stack)) {
        printf("Stack Underflow\n");
        return '\0';
    }
    char element = stack->data[stack->top];
    stack->top--;
    return element;
}

char peek(Stack* stack) {
    if (is_empty(stack)) {
        printf("Stack is Empty\n");
        return '\0';
    }
    return stack->data[stack->top];
}

int main() {
    Stack stack;
    init_stack(&stack);

    push(&stack, 'a');
    push(&stack, 'b');
    push(&stack, 'c');

    printf("Top element is: %c\n", peek(&stack));

    pop(&stack);
    pop(&stack);

    printf("Top element after popping twice is: %c\n", peek(&stack));

    return 0;
}