//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// A structure to represent a point in 2D space
typedef struct Point {
    double x;
    double y;
} Point;

// A structure to represent a line segment in 2D space
typedef struct LineSegment {
    Point p1;
    Point p2;
} LineSegment;

// A function to check if two points are equal
int are_equal(Point p1, Point p2) {
    return (p1.x == p2.x) && (p1.y == p2.y);
}

// A function to check if two line segments intersect
int do_intersect(LineSegment l1, LineSegment l2) {
    // Check if the two line segments are parallel
    if ((l1.p1.x - l1.p2.x) * (l2.p1.y - l2.p2.y) == (l1.p1.y - l1.p2.y) * (l2.p1.x - l2.p2.x)) {
        return 0;
    }

    // Check if the two line segments intersect at one of the endpoints
    if (are_equal(l1.p1, l2.p1) || are_equal(l1.p1, l2.p2) || are_equal(l1.p2, l2.p1) || are_equal(l1.p2, l2.p2)) {
        return 1;
    }

    // Check if the two line segments intersect at a point between the endpoints
    double x1 = l1.p1.x;
    double y1 = l1.p1.y;
    double x2 = l1.p2.x;
    double y2 = l1.p2.y;
    double x3 = l2.p1.x;
    double y3 = l2.p1.y;
    double x4 = l2.p2.x;
    double y4 = l2.p2.y;

    double t1 = ((x3 - x1) * (y2 - y1) - (y3 - y1) * (x2 - x1)) / ((x3 - x4) * (y2 - y1) - (y3 - y4) * (x2 - x1));
    double t2 = ((x1 - x3) * (y4 - y3) - (y1 - y3) * (x4 - x3)) / ((x1 - x2) * (y4 - y3) - (y1 - y2) * (x4 - x3));

    if (t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1) {
        return 1;
    }

    return 0;
}

// A function to test the do_intersect function
int main() {
    // Create two line segments
    LineSegment l1 = {{0, 0}, {1, 1}};
    LineSegment l2 = {{0, 1}, {1, 0}};

    // Check if the two line segments intersect
    if (do_intersect(l1, l2)) {
        printf("The two line segments intersect.\n");
    } else {
        printf("The two line segments do not intersect.\n");
    }

    return 0;
}