//GEMINI-pro DATASET v1.0 Category: Procedural Space Adventure ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define PARANOIA_LEVEL 10

int main(int argc, char **argv) {
    // Seed the random number generator with a paranoid amount of entropy
    srand(time(NULL) ^ getpid() ^ clock());

    // Create a procedurally generated space adventure!
    char *playerName = "Paranoia";
    int playerHealth = 100;
    int playerAttack = 10;
    int playerDefense = 5;

    // Generate a random alien enemy
    char *enemyName = "The Xarpti";
    int enemyHealth = 100;
    int enemyAttack = 15;
    int enemyDefense = 10;

    // Begin the space adventure!
    printf("Welcome to the Procedurally Generated Space Adventure, %s!\n", playerName);
    printf("You are facing %s, a formidable alien enemy.\n", enemyName);

    // Enter the main game loop
    while (playerHealth > 0 && enemyHealth > 0) {
        // Player's turn
        int playerDamage = playerAttack - enemyDefense;
        if (playerDamage < 0) {
            playerDamage = 0;
        }
        enemyHealth -= playerDamage;
        printf("%s attacks %s for %d damage!\n", playerName, enemyName, playerDamage);

        // Enemy's turn
        int enemyDamage = enemyAttack - playerDefense;
        if (enemyDamage < 0) {
            enemyDamage = 0;
        }
        playerHealth -= enemyDamage;
        printf("%s attacks %s for %d damage!\n", enemyName, playerName, enemyDamage);

        // Check for paranoia
        if (rand() % PARANOIA_LEVEL == 0) {
            printf("Paranoia strikes! %s suddenly attacks %s for %d damage!\n", playerName, playerName, rand() % 20);
            playerHealth -= rand() % 20;
        }
    }

    // End the game
    if (playerHealth <= 0) {
        printf("Game over! %s has been defeated by %s.\n", playerName, enemyName);
    } else {
        printf("Victory! %s has defeated %s.\n", playerName, enemyName);
    }

    return 0;
}