//GPT-4o-mini DATASET v1.0 Category: Traffic Flow Simulation ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define CARS 10
#define RED_LIGHT_DURATION 3
#define GREEN_LIGHT_DURATION 5

typedef enum { RED, GREEN } TrafficLight;

void a_car_horn() {
    printf("Honk! Honk! Watch out, I'm coming through!\n");
}

void traffic_light(TrafficLight light) {
    if (light == RED) {
        printf("🚦 The traffic light is RED! 🛑\n");
        sleep(RED_LIGHT_DURATION);
    } else {
        printf("🚦 The traffic light is GREEN! 🟢\n");
        sleep(GREEN_LIGHT_DURATION);
    }
}

void car_on_road(int car_id) {
    printf("Car %d is cruising down Bumper Cars Boulevard. \n", car_id);
    sleep(rand() % 3 + 1); // Cars move at random speeds
    a_car_horn();
}

void run_simulation() {
    // Seed random number generator
    srand(time(NULL));

    printf("Welcome to Bumper Cars Boulevard traffic simulation! Buckle up! 🚗💨\n");

    // Start the simulation
    while (1) {
        for (int light_cycle = 0; light_cycle < 5; light_cycle++) {
            // Let the cars go through the red light, because why not?
            if (light_cycle % 2 == 0) {
                traffic_light(RED);
            } else {
                traffic_light(GREEN);
            }

            // Create and simulate traffic flow with "CARS"
            for (int car_id = 1; car_id <= CARS; car_id++) {
                if (light_cycle % 2 == 1) { // Only let cars go during GREEN light
                    car_on_road(car_id);
                } else {
                    printf("Car %d is stuck, confused about the red light! 🚧😵‍💫\n", car_id);
                    sleep(1); // Cars sulk for a moment when the light is red
                }
            }

            printf("\n_______________________________\n");
        }
        // Run for a few cycles, then take a break for lunch - as all good simulations must!
        printf("Bumper Cars Boulevard simulation has concluded for now. Time for a snack! 🍔🍕\n");
        break; // Stop the simulation to prevent getting lost forever!
    }
}

int main() {
    run_simulation();
    return 0;
}