//Falcon-180B DATASET v1.0 Category: Searching algorithm ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 10

// Function to generate random numbers between 1 and 100
int rand_num() {
    return rand() % 100 + 1;
}

// Function to print the array
void print_array(int arr[], int size) {
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Function to search for an element in the array
int search(int arr[], int size, int target) {
    for (int i = 0; i < size; i++) {
        if (arr[i] == target) {
            return i;
        }
    }
    return -1;
}

// Function to shuffle the array
void shuffle(int arr[], int size) {
    srand(time(NULL));
    for (int i = 0; i < size; i++) {
        int j = rand() % size;
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
    }
}

int main() {
    // Initialize the array
    int arr[SIZE];
    for (int i = 0; i < SIZE; i++) {
        arr[i] = rand_num();
    }

    // Print the original array
    printf("Original array:\n");
    print_array(arr, SIZE);

    // Shuffle the array
    shuffle(arr, SIZE);

    // Print the shuffled array
    printf("Shuffled array:\n");
    print_array(arr, SIZE);

    // Search for an element in the shuffled array
    int target = rand_num();
    int result = search(arr, SIZE, target);

    if (result == -1) {
        printf("Element not found\n");
    } else {
        printf("Element found at index %d\n", result);
    }

    return 0;
}