//Falcon2-11B DATASET v1.0 Category: Drone Remote Control ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Struct to represent a drone
typedef struct {
    int x;
    int y;
    int heading;
    int speed;
    int max_distance;
} Drone;

// Function to check if the drone is within the remote control distance
bool check_distance(Drone *drone) {
    return drone->x * drone->x + drone->y * drone->y <= drone->max_distance * drone->max_distance;
}

// Function to move the drone in a given direction for a given distance
void move_drone(Drone *drone, int direction, int distance) {
    switch(direction) {
        case 0:
            drone->x += distance;
            break;
        case 1:
            drone->y += distance;
            break;
        case 2:
            drone->heading += distance;
            break;
        default:
            break;
    }
}

// Function to stop the drone
void stop_drone(Drone *drone) {
    drone->speed = 0;
}

int main() {
    Drone drone;
    drone.x = 0;
    drone.y = 0;
    drone.heading = 0;
    drone.speed = 0;
    drone.max_distance = 100;

    // Test the check_distance function
    printf("Is the drone within the remote control distance? %s\n", check_distance(&drone)? "Yes" : "No");

    // Test the move_drone function
    move_drone(&drone, 1, 10);
    printf("New position: (%d, %d)\n", drone.x, drone.y);

    // Test the stop function
    stop_drone(&drone);
    printf("Speed: %d\n", drone.speed);

    return 0;
}