//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define N 5 // Size of the maze

// Function prototypes
void printMaze(int maze[N][N]);
bool isSafe(int maze[N][N], int x, int y);
bool findPath(int maze[N][N], int x, int y, int solution[N][N]);
void solveMaze(int maze[N][N]);

int main() {
    // Maze definition (0 - path, 1 - wall)
    int maze[N][N] = {
        {0, 1, 0, 0, 0},
        {0, 1, 0, 1, 0},
        {0, 0, 0, 1, 0},
        {0, 1, 0, 0, 0},
        {0, 0, 1, 1, 0}
    };

    solveMaze(maze);
    return 0;
}

// Function to print the maze
void printMaze(int maze[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            if (maze[i][j] == 1) {
                printf("█ ");  // Wall
            } else {
                printf("  ");  // Path
            }
        }
        printf("\n");
    }
}

// Function to check if x, y is valid index for N*N maze
bool isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 0);
}

// Function to solve the maze using backtracking
bool findPath(int maze[N][N], int x, int y, int solution[N][N]) {
    // If we reach the bottom-right corner, we've found a solution
    if (x == N - 1 && y == N - 1) {
        solution[x][y] = 1;
        return true;
    }

    // Check if current position is safe
    if (isSafe(maze, x, y)) {
        // Mark x, y as part of the solution path
        solution[x][y] = 1;

        // Move forward in x direction
        if (findPath(maze, x + 1, y, solution)) {
            return true;
        }

        // If moving in x direction doesn't give a solution then move down in y direction
        if (findPath(maze, x, y + 1, solution)) {
            return true;
        }

        // If none of the above movements work then BACKTRACK
        solution[x][y] = 0;
        return false;
    }
    
    return false;
}

// Function to solve the Maze problem
void solveMaze(int maze[N][N]) {
    int solution[N][N] = { {0} }; // Solution matrix

    if (findPath(maze, 0, 0, solution) == false) {
        printf("No solution exists\n");
        return;
    }

    // Print the solution matrix
    printMaze(solution);
}