//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: careful
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name[], int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item list full!\n");
}

void showItems() {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

int calculateTotal() {
    int total = 0;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            total += items[i].quantity * items[i].price;
        }
    }

    return total;
}

void generateBill(int total) {
    printf("----------------------------------------\n");
    printf("C Cafe Bill\n");
    printf("----------------------------------------\n");
    printf("Items:\n");
    showItems();
    printf("\nTotal: $%d\n", total);
    printf("\nThank you for your visit!\n");
    printf("----------------------------------------\n");
}

int main() {
    addItem("Coffee", 5, 2.50);
    addItem("Tea", 3, 1.50);
    addItem("Juice", 2, 1.20);

    int total = calculateTotal();
    generateBill(total);

    return 0;
}